<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\UsingProductModel;
use App\UsingProductStock;
use App\ProductConModel;
use Illuminate\Support\Facades\Crypt;
use App\CategoryConStockModel;
use DataTables;

class UsingProduct extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Using-Construction-List', ['only' => ['index','using_get_list']]);
         $this->middleware('permission:Using-Construction-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Using-Construction-Show', ['only' => ['show']]);
         $this->middleware('permission:Using-Construction-Return', ['only' => ['return_stock','return_stock_store']]);
         $this->middleware('permission:Using-Construction-Return-Print',['only'=>['using_print']]);
    }
    public function index()
    {
        return view("construction-stock.usings.index");
    }
    public function using_get_list(Request $request)
    {
        $usings=DB::table("nso007_using")->join("nso007_block","nso007_block.id","nso007_using.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->select("nso007_project_stock.name as project_name","nso007_block.name","nso007_using.date","nso007_using.id","nso007_using.person_use","nso007_using.remark")->orderBy("nso007_using.date","DESC")->get();
        return Datatables::of($usings)
               ->addIndexColumn()
               ->editColumn("date",function($usings){
                   return date("d-m-Y",strtotime($usings->date));
               })
               ->addColumn("action",function($usings){
                $button = "";
                $button .= '<a href="'.route('usings.show',Crypt::encrypt($usings->id)).'" class="btn-sm btn-primary btn"><i class="fa fa-eye"></i></a> ';
                $button .= ' <a href="'.route('usings.using_print',Crypt::encrypt($usings->id)).'" class="btn-sm btn-info btn" title="Invoice"><i class="fa fa-file"></i></a>';
                $button .= ' <a href="javascript:void(0)" onclick = "view_delete(this)" using_id = "'.Crypt::encrypt($usings->id).'" class="btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></a>';
                return $button;
               })
               ->rawColumns(['action'=>'action'])
               ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category=CategoryConStockModel::pluck("pcat_name","pcat_id")->prepend("Please Select");
        $blogs=DB::table("nso007_block")->join("nso007_project_stock",'nso007_block.project_id','nso007_project_stock.id')
        ->select(DB::raw('CONCAT(nso007_project_stock.name," | ",nso007_block.name) AS blog_name'),'nso007_block.id')->pluck("blog_name","id")->prepend("Please Select","");

        $products=DB::table('nso007_product_stock')->join("product",'product.id','nso007_product_stock.product_id')->join('unit','unit.id','product.pro_unit_id')->where('pro_qty','>',0)->select("product.*","unit.unit_name","nso007_product_stock.balance_qty")->groupBy('nso007_product_stock.product_id')->get();

        return view("construction-stock.usings.create",compact('blogs','products','category'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'blog_id'=>'required|integer|min:1',
            'date'=>'required',
            'product_id'=>'required',
            'product_qty'=>'required'
        ]);
        $blog_id=$request->blog_id;
        $date=$request->date;
        $products=$request->product_id;
        $product_qty=$request->product_qty;

        $productInvoice=DB::table('nso007_using')->select(DB::raw("MAX(invoice) as InvoiceNum"))->first();
        $productusing=new UsingProductModel;
        $productusing->date=date("Y-m-d",strtotime($date));
        $productusing->blog_id=$blog_id;
        $productusing->invoice=$productInvoice->InvoiceNum+1;
        $productusing->person_use = $request->person_use;
        $productusing->remark = $request->remark;
        $productusing->save();

        $productusing_id=$productusing->id;

        $index=count($products);

        for($i=0;$i<$index;$i++) {
            $productusingstock=new UsingProductStock;
            $productusingstock->using_id=$productusing_id;
            $productusingstock->product_id=$products[$i];
            $productusingstock->qty=$product_qty[$i];
            $productusingstock->save();

            $pur_pro=DB::table('nso007_product_stock')->where('product_id',$products[$i])->where('blog_id',$blog_id)->select("*")->first();
            DB::table('nso007_product_stock')->where('product_id',$products[$i])->where('blog_id',$blog_id)->update(['using_qty'=>($pur_pro->using_qty+$product_qty[$i]),'balance_qty'=>($pur_pro->balance_qty-$product_qty[$i])]);

            $productqty=DB::table('product')->select('pro_qty')->where('id',$products[$i])->first();
            $product=ProductConModel::find($products[$i]);
            $product->pro_qty=$productqty->pro_qty-$product_qty[$i];
            $product->save();

        }

        return redirect()->route('usings.index')->with("success","product have used!");

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $using_id=Crypt::decrypt($id);

        $blog_id=DB::table("nso007_using")->select("blog_id")->where("id",$using_id)->first();
        
        $usings_stock=DB::select("SELECT * FROM nso007_using_stock INNER JOIN (SELECT pro_name,pcat_name,unit_name,balance_qty,product_id as pro_id FROM nso007_product_stock INNER JOIN product ON product.id=nso007_product_stock.product_id INNER JOIN nso007_category_construction ON nso007_category_construction.pcat_id=product.pro_category_id INNER JOIN unit ON unit.id=product.pro_unit_id WHERE nso007_product_stock.blog_id=$blog_id->blog_id) as product_stock ON nso007_using_stock.product_id=product_stock.pro_id WHERE nso007_using_stock.using_id=$using_id");
        // dd($usings_stock);

        return view("construction-stock.usings.show",compact('usings_stock'));
    }

    public function return_stock()
    {
        $blogs=DB::table("nso007_block")->join("nso007_project_stock",'nso007_block.project_id','nso007_project_stock.id')
        ->select(DB::raw('CONCAT(nso007_project_stock.name," | ",nso007_block.name) AS blog_name'),'nso007_block.id')->pluck("blog_name","id")->prepend("please select");

        $products=DB::table("product")->join('unit','unit.id','product.pro_unit_id')->select("product.*","unit.unit_name")->get();

        return view("construction-stock.usings.return",compact('blogs','products'));
    }

    public function return_stock_store(Request $request)
    {
        $this->validate($request,[
            'invoice'=>'required',
            'product_id'=>'required',
            'product_qty'=>'required'
        ]);

        $invoice=$request->invoice;
        $products=$request->product_id;
        $product_qty=$request->product_qty;
        
        $UsingProduct=UsingProductModel::where("invoice",$invoice)->select("id",'blog_id')->first();
        $using_id=optional($UsingProduct)->id;
        if(!empty($using_id)){
            $count=count($products);
            for ($i=0;$i<$count;$i++) {
                $usingstock=DB::table("nso007_using_stock")->where("using_id",$using_id)->where("product_id", $products[$i])->select("id","return_qty","qty")->first();
                if(empty($usingstock)||$usingstock->qty<($usingstock->return_qty+$product_qty[$i])) {
                    return \back()->with("warning","Your request is failed.");
                }
            }

            for ($i=0;$i<$count;$i++) {
                $usingstock=DB::table("nso007_using_stock")->where("using_id",$using_id)->where("product_id", $products[$i])->select("id","return_qty")->first();
                $stockusing=UsingProductStock::find($usingstock->id);
                $stockusing->return_qty=$usingstock->return_qty+$product_qty[$i];
                $stockusing->save();

                $pur_pro=DB::table('nso007_product_stock')->where('product_id',$products[$i])->where('blog_id',$UsingProduct->blog_id)->select("*")->first();
                DB::table('nso007_product_stock')->where('product_id',$products[$i])->where('blog_id',$UsingProduct->blog_id)->update(['product_id'=>$products[$i],'blog_id'=>$UsingProduct->blog_id,'using_qty'=>($pur_pro->using_qty-$product_qty[$i]),'balance_qty'=>($pur_pro->balance_qty+$product_qty[$i])]);

                $productqty=DB::table('product')->select('pro_qty')->where('id',$products[$i])->first();
                $product=ProductConModel::find($products[$i]);
                $product->pro_qty=$productqty->pro_qty+$product_qty[$i];
                $product->save();
            }
        }else{
            return redirect()->route("usings.index")->with("warning","Your request is fail !"); 
        }
        return redirect()->route("usings.index")->with("success","Your request is successful !"); 
    }
    public function return_get_item(Request $request)
    {
        $invoice=$request->invoice;
        $using=UsingProductModel::where("invoice",$invoice)->select("id")->first();
        $products=UsingProductStock::where("using_id",$using->id)->join("product","product.id","nso007_using_stock.product_id")->join("unit","id","pro_unit_id")->select("pro_code","pro_name","product_id","unit_name")->get();
        return json_encode($products);
    }
    public function using_print($id)
    {
        $id=Crypt::decrypt($id); 
         $usingproducts=DB::table('nso007_using_stock')
                ->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
                ->join("product","product.id","nso007_using_stock.product_id")
                ->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")
                ->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_block","nso007_block.id","nso007_using.blog_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
                ->select("nso007_using.date","nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name")
                ->where("nso007_using_stock.using_id",$id)
                ->groupBy("nso007_using_stock.id")
                ->get();

        $using=DB::table("nso007_using")->select("invoice")->where("id",$id)->first();
        return view("construction-stock.usings.print",compact('usingproducts','using')); 
    }
    public function delete(){
        
        $id = $_GET['using_id'];
        $using_id=Crypt::decrypt($id);
        $get_using = UsingProductModel::find($using_id);
        if(!empty($get_using)){
            $get_using_stock = UsingProductStock::where("using_id",$using_id)->get();
            
            if(!empty($get_using_stock)&&count($get_using_stock)>0){
                // dd($get_using_stock);
                foreach($get_using_stock  as $using_key=>$value ){
                    //Decrease Stock Using
                    DB::table('nso007_product_stock')->where('product_id',$value->product_id)->where('blog_id',$get_using->blog_id)
                    ->update(['using_qty'=>DB::raw("using_qty - ".($value->qty - $value->return_qty)),'balance_qty'=>DB::raw('balance_qty + '.($value->qty - $value->return_qty))]);

                    //Decrease Qty Product
                    ProductConModel::where("id",$value->product_id)->update(["pro_qty"=>DB::raw("pro_qty  + ".($value->qty - $value->return_qty))]);
                }
                //Delete Using Stock Detail
                UsingProductStock::where("using_id",$using_id)->delete();

                //Delete Using Stock
                UsingProductModel::where("id",$using_id)->delete();
            }else{
                return \back()->with("warning","Can't Delete");
            }
        }else{
            return \back()->with("warning","Can't Delete");
        }
        return \back()->with("success","Delete successfully !");
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
