<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\UnitModel;

class UnitConController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Unit-Construction-List', ['only' => ['index']]);
         $this->middleware('permission:Unit-Construction-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Unit-Construction-Update', ['only' => ['update']]);
    }
    public function index(){
    	$unit=UnitModel::all();
    	return view('construction-stock.units.index',['data'=>$unit]);
    }
    public function create(){
    	return view('construction-stock.units.create');
    }
    public function store(Request $request){
    	$this->validate($request,[
    		'unit_name'=>'required',
    	]);
    	$unit= new UnitModel;
    	$unit->unit_name=$request->input('unit_name');
    	$unit->unit_des=$request->input('unit_des');
    	$unit->save();
    	return redirect()->route('unit.index')->with("success","Unit is created");
    }
    public function update(Request $request){
    	$this->validate($request,[
    		'unit_name'=>'required'
    	]);
    	$id=$request->input('unit_id');
    	$name=$request->input('unit_name');
    	$des=$request->input('unit_des');
    	$unit=UnitModel::find($id);
    	$unit->unit_name=$name;
    	$unit->unit_des=$des;
    	$unit->save();
    	return redirect()->route('unit.index');
    }
}
