<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Auth;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     function __construct()
     {
        $this->middleware('permission:Setting-Commission-Condition', ['only' => ['commission_condition','store_commission_condition','edit_commission_condition','store_edit_commission_condition']]);
     }
    public function commission_condition()
    {
        $data = DB::table('nso007_commission_condition_setting')->where('status',1)->get();
        return view('setting.commission_condition',compact('data'));
    }
    public function store_commission_condition(Request $request)
    {
        $this->validate($request,[
            'title'=>'required',
            'type'=>'required',
            'condition'=>'required',
            'withdrawable'=>'required'
        ]);

        DB::beginTransaction();
        try{

            DB::table('nso007_commission_condition_setting')->insert(['title'=>$request->title,'description'=>$request->description,'user_id'=>Auth::user()->id]);
            $last_id = DB::table('nso007_commission_condition_setting')->latest('id')->first()->id;

            $commission_condition = "";
            foreach ($request->withdrawable as $key => $value) {
                $commission_condition = "";
                $commission_condition=$request->condition[$key];
                DB::table('nso007_commission_condition_detail_setting')->insert(['commission_condition_id'=>$last_id,'can_withdraw_condion'=>$value,'commission_condition'=>$commission_condition,'commission_type'=>$request->type[$key]]);
            }

            DB::commit();
            return redirect()->route('commission_condition')->with('success','your request is successfull !');
        }catch(\Exception $e){
            DB::rollback();
            return redirect()->back()->with('warning','Error with your request !'.$e);
        }
    }
    public function edit_commission_condition($id)
    {
        $data = array(
            "id"=>$id,
            "commission_condition"=>DB::table("nso007_commission_condition_setting")->where('id',$id)->first(),
            "commission_condition_detail"=>DB::table('nso007_commission_condition_detail_setting')->where("commission_condition_id",$id)->get()
        );
        return json_encode($data);
    }
    public function store_edit_commission_condition(Request $request)
    {
        $this->validate($request,[
            'title'=>'required',
            'type'=>'required',
            'condition'=>'required',
            'withdrawable'=>'required',
            'commission_condition_id'=>'required'
        ]);
        DB::beginTransaction();
        try{
            DB::table('nso007_commission_condition_setting')->where('id',$request->commission_condition_id)->update(['title'=>$request->title,'description'=>$request->description]);
            DB::table('nso007_commission_condition_detail_setting')->where('commission_condition_id',$request->commission_condition_id)->delete();
            $last_id = $request->commission_condition_id;
            foreach ($request->withdrawable as $key => $value) {
                DB::table('nso007_commission_condition_detail_setting')->insert(['commission_condition_id'=>$last_id,'can_withdraw_condion'=>$value,'commission_condition'=>$request->condition[$key],'commission_type'=>$request->type[$key]]);
            }
            DB::commit();
            return redirect()->route('commission_condition')->with('success','your request is successfull !');
        }catch(\Exception $e){
            DB::rollback();
            return redirect()->back()->with('warning','Error with your request !');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
