<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProjectModel;
use App\SupplierModel;
use App\ProductConModel;
use App\BlockModel;
use DB;
use Auth;
use App\PurchaseModel;
use App\PurchaseStockModel;
use Illuminate\Support\Facades\Crypt;
use App\CategoryConStockModel;
use DataTables;
use Image;

class PurchaseProductController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Purchase-Construction-List', ['only' => ['index','get_purchase_list']]);
         $this->middleware('permission:Purchase-Construction-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Purchase-Construction-Show', ['only' => ['show']]);
    }
    public function index()
    {
        return view('construction-stock.purchase.index');
    }
    public function get_purchase_list(Request $request){
        $purchases=DB::table('nso007_purchase')
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_block","nso007_block.id","nso007_purchase.blog_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->select("nso007_purchase.date",
                    "nso007_purchase.date_purchase",
                    "nso007_block.name",
                    "nso007_purchase.id",
                    "nso007_project_stock.name as project_name",
                    "construction_supplier.supp_name",
                    "construction_supplier.supp_phone",
                    "nso007_purchase.total_amount",
                    "nso007_purchase.person_recieve",
                    "nso007_purchase.invoice_num")
                ->orderBy("nso007_purchase.date_purchase","DESC")
                ->get();
        return Datatables::of($purchases)
               ->addIndexColumn()
               ->addColumn('action',function($purchases){
                   $button = '<a href="'.route('purchases.show',Crypt::encrypt($purchases->id)).'" class="btn-sm btn-info btn" title="view purchase details"><i class="fa fa-eye"></i></a>';
                   $button .= ' <a href="javascript:void(0)" onclick="show_image('.$purchases->id.')" class="btn-sm btn-primary btn" title="view Image"><i class="fas fa-images"></i></a>';
                   $button .= ' <a href="'.route('purchases.edit',Crypt::encrypt($purchases->id)).'" class="btn-sm btn-primary" title="Edit"><i class="fa fa-edit"></i></a>';
                   $button .= ' <a href="javascript:void(0)" onclick = "view_delete(this)" purchase_id = "'.Crypt::encrypt($purchases->id).'" class="btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></a>';
                return $button;
               })
               ->editColumn('date_purchase',function ($purchase)
               {
                   return date("d-m-Y",strtotime($purchase->date_purchase));
               })
               ->editColumn('total_amount',function($purchase){
                   return number_format($purchase->total_amount,2)."$";
               })
               ->rawColumns(['action'=>'action'])
               ->make(true);
    }
    public function show_purchase_image($id){
        $data = DB::table("nso007_purchase_image")->where("purchase_id",$id)->select("image_name")->get();
        if(!empty($data)&&count($data)>0){
            $return_value = array();
            foreach($data as $key=>$value){
                $return_value[$key]=asset('assets/img/upload/'.optional($value)->image_name);
            }
            return ["status"=>true,"image"=>$return_value];
        }
        else return ["status"=>false];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category=CategoryConStockModel::pluck("pcat_name","pcat_id")->prepend("Please Select","");
        $suppliers=SupplierModel::pluck("supp_name","id")->prepend("Please Select","");
        $projects=ProjectModel::pluck("name","id")->prepend("Please Select","");
        $products=ProductConModel::join("unit",'unit.id','product.pro_unit_id')->select("product.*","unit.unit_name")->get();
        $blogs=DB::table("nso007_block")->join('nso007_project_stock',"nso007_block.project_id","nso007_project_stock.id")->select(DB::raw("CONCAT(nso007_project_stock.name,' | ',nso007_block.name) AS blog"),'nso007_block.id')->pluck('blog',"id")->prepend("Please Select","");

        return view('construction-stock.purchase.create',compact("suppliers","projects","products",'blogs','category'));
    }

    public function get_product_by_cate_purchase(Request $request)
    {
        $cate_id=$request->pro_category_id;
        $products=DB::table("product")->join("unit",'unit.id','product.pro_unit_id')->select("product.*","unit.unit_name")->where("pro_category_id",$cate_id)->get();
        return json_encode($products);
    }

    public function get_product_by_cate(Request $request)
    {
        $blog_id=$request->blog_id;
        $cate_id=$request->pro_category_id;
        $products=DB::table('nso007_product_stock')->join("product",'product.id','nso007_product_stock.product_id')->join("unit",'unit.id','product.pro_unit_id')->select("product.*","unit.unit_name","nso007_product_stock.balance_qty")->where("pro_category_id",$cate_id)->where('blog_id',$blog_id)->groupBy('nso007_product_stock.product_id')->get();
        return json_encode($products);
    }

    // /**
    //  * Store a newly created resource in storage.
    //  *
    //  * @param  \Illuminate\Http\Request  $request
    //  * @return \Illuminate\Http\Response
    //  */
    public function get_blog_by_project(Request $request)
    {
        return json_encode($request->project_id);
    }
    public function store(Request $request)
    {

        $this->validate($request,[
            'suppliers'     =>'required',
            'project'       =>'required',
            'purchase_date' =>'required',
            'product_code'  =>'required',
            'product_name'  =>'required',
            'product_price' =>'required',
            'product_qty'   =>'required',
            'blog_id'       =>'required',
            'invoice'       =>'required',
            'image.*' => 'mimes:jpeg,png,jpg,gif,svg|max:1024',
        ]);
        $supp       = $request->input("suppliers");
        $proj       = $request->input("project");
        $pur_date   = $request->input('purchase_date');
        $pro_code   = $request->input('product_code');
        $pro_name   = $request->input('product_name');
        $pro_price  = $request->input('product_price');
        $pro_qty    = $request->input('product_qty');
        $product_id = $request->input('product_id');
        $blog       = $request->input('blog_id');
        $invoice    = $request->input('invoice');

        $TotalCount=count($pro_code);
        $totalAmount=0;
        $purchase=new PurchaseModel;
        $purchase->date=date('Y-m-d');
        $purchase->date_purchase=date('Y-m-d',strtotime($pur_date));
        $purchase->blog_id=$blog;
        $purchase->supplier_id=$supp;
        $purchase->total_amount= $totalAmount;
        $purchase->invoice_num=$invoice;
        $purchase->person_recieve = $request->person_recieve;
        $purchase->save();
        $purchase_id=$purchase->id;

        if ($request->hasFile('image_invoice')) {
            $image_in = $request->file('image_invoice');
            foreach ($image_in as $key_in=>$files_in) {
                $destinationPath_invoice = public_path('/assets/img/upload');
                $file_name_invoice = "product-purchase".$key_in.time().".". $files_in->getClientOriginalExtension();
                $files_in->move($destinationPath_invoice, $file_name_invoice);
                DB::table("nso007_purchase_image")->insert(['image_name'=>$file_name_invoice,"purchase_id"=>$purchase_id]);
            }
        }

        for($i=0;$i<$TotalCount;$i++){
            $productqty=DB::table('product')->select('pro_qty')->where('id',$product_id[$i])->first();
            $product=ProductConModel::find($product_id[$i]);
            $product->pro_price=$pro_price[$i];
            $product->pro_qty=$productqty->pro_qty+$pro_qty[$i];
            $product->save();

            $pur_pro=DB::table('nso007_product_stock')->where('product_id',$product_id[$i])->where('blog_id',$blog)->select("*")->first();
            if(!empty($pur_pro)){
                DB::table('nso007_product_stock')->where('product_id',$product_id[$i])->where('blog_id',$blog)->update(['purchase_qty'=>($pur_pro->purchase_qty+$pro_qty[$i]),'balance_qty'=>($pur_pro->balance_qty+$pro_qty[$i])]);
            }else{
                DB::table('nso007_product_stock')->insert(['product_id'=>$product_id[$i],'blog_id'=>$blog,'purchase_qty'=>$pro_qty[$i],'balance_qty'=>$pro_qty[$i]]);
            }

            $totalAmount+=$pro_price[$i]*$pro_qty[$i];

            $purchase_stock=new PurchaseStockModel;
            $purchase_stock->purchase_id=$purchase_id;
            $purchase_stock->product_id=$product_id[$i];
            $purchase_stock->unit_price=$pro_price[$i];
            $purchase_stock->qty=$pro_qty[$i];
            $purchase_stock->amount=$pro_price[$i]*$pro_qty[$i];
            $purchase_stock->remark = $request->remark[$i];
            $purchase_stock->save();

            DB::table('product')->where("id",$product_id[$i])->update(['delete_status'=>1]);

            if ($request->hasFile($pro_code[$i])) {
                $image = $request->file($pro_code[$i]);
                foreach ($image as $key=>$files) {
                    $destinationPath = public_path('/assets/img/upload');
                    $file_name = "product-purchase".$key.time().".". $files->getClientOriginalExtension();
                    // $img = Image::make($files->getRealPath());
                    // $img->save($destinationPath.'/'.$file_name);
                    $files->move($destinationPath, $file_name);
                    DB::table("nso007_purchase_stock_image")->insert(['image_name'=>$file_name,"purchase_stock_id"=>$purchase_stock->id]);
                }
            }
        }
        $purchase_m=PurchaseModel::find($purchase_id);
        $purchase_m->total_amount= $totalAmount;
        $purchase_m->save();
        $last_purchase_id = PurchaseModel::max('id');
        $last_purchase = PurchaseModel::where('id',$last_purchase_id)->first();

        $supplier=DB::table('construction_supplier')->select("supp_name","supp_phone")->where("id",$supp)->first();
        //Accounting
        //End accouting
        return redirect()->route('purchases.index');
    }

    // /**
    //  * Display the specified resource.
    //  *
    //  * @param  int  $id
    //  * @return \Illuminate\Http\Response
    //  */
    public function show($id)
    {
        $purchase_id=Crypt::decrypt($id);
        $purchase_details=PurchaseStockModel::where("purchase_id",$purchase_id)
            ->join("product","product.id","nso007_purchase_stock.product_id")
            ->join("nso007_category_construction","nso007_category_construction.pcat_id","product.pro_category_id")
            ->join("unit","unit.id","product.pro_unit_id")
            ->select("pro_code",
                    "pro_name",
                    "unit_name",
                    "pcat_name",
                    "nso007_purchase_stock.id",
                    "nso007_purchase_stock.unit_price",
                    "nso007_purchase_stock.qty",
                    "nso007_purchase_stock.amount",
                    "nso007_purchase_stock.remark"
                    )
            ->get();
            
        return view("construction-stock.purchase.purchasedetails",compact('purchase_details'));
    }
    public function show_purchase_product_image($purchase_stock_id){
        $data = DB::table("nso007_purchase_stock_image")->where("purchase_stock_id",$purchase_stock_id)->select("image_name")->get();
        if(!empty($data)&&count($data)>0){
            $return_value = array();
            foreach($data as $key=>$value){
                $return_value[$key]=asset('assets/img/upload/'.optional($value)->image_name);
            }
            return ["status"=>true,"image"=>$return_value];
        }
        else return ["status"=>false];
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(){
        
        $id = $_GET['purchase_id'];
        $purchase_id=Crypt::decrypt($id);
        
        $get_products = PurchaseStockModel::where("purchase_id",$purchase_id)->get();
        // dd($purchase_id);
        $get_purchase = PurchaseModel::find($purchase_id);
        if(!empty($get_products)&&count($get_products)>0&&!empty($get_purchase)){
            $can_delete = false;
            foreach($get_products as $get_product){
                $check_using = DB::table('nso007_product_stock')->where('product_id',$get_product->product_id)->where("balance_qty","<",$get_product->qty)->where('blog_id',$get_purchase->blog_id)->first();
                
                if(@$get_product->qty>@$check_using->balance_qty){
                    $can_delete = true;
                }
            }
            if($can_delete==true){
                return \back()->with("warning","can't delete this record!");
            }
            else{
                foreach($get_products as $p_key=>$value){
                    #Decrease Product Stock
                    DB::table('nso007_product_stock')->where('product_id',$value->product_id)->where('blog_id',$get_purchase->blog_id)->update(['purchase_qty'=>DB::raw("purchase_qty - ".$value->qty),'balance_qty'=>DB::raw('balance_qty - '.$value->qty)]);
                    #Decrease Product
                    ProductConModel::where("id",$value->product_id)->update(["pro_qty"=>DB::raw('pro_qty - '.$value->qty)]);  
                }
                PurchaseStockModel::where("purchase_id",$purchase_id)->delete();//Delete Purchase Detail
                PurchaseModel::where("id",$purchase_id)->delete();//Delete Purchase 
            }
        }else{
            return \back()->with("warning","can't delete this record !");
        }
        return \back()->with("success","Delete successfully !");
    }
    public function edit($id)
    {
       $id = Crypt::decrypt($id);
       $data = PurchaseModel::where("id",$id)->first();
       $project_id = optional(BlockModel::find($data->blog_id))->project_id;
       $data_details=PurchaseStockModel::where("purchase_id",$id)
            ->join("product","product.id","nso007_purchase_stock.product_id")
            ->join("nso007_category_construction","nso007_category_construction.pcat_id","product.pro_category_id")
            ->join("unit","unit.id","product.pro_unit_id")
            ->select("pro_code","product.id as pro_id",
                        "pro_name",
                        "unit_name",
                        "pcat_name","product.pro_unit_id as unit_id",
                        "nso007_purchase_stock.id",
                        "nso007_purchase_stock.unit_price",
                        "nso007_purchase_stock.qty",
                        "nso007_purchase_stock.amount",
                        "nso007_purchase_stock.remark"
                    )
            ->get();

            $category=CategoryConStockModel::pluck("pcat_name","pcat_id")->prepend("Please Select","");
            $suppliers=SupplierModel::pluck("supp_name","id")->prepend("Please Select","");
            $projects=ProjectModel::pluck("name","id")->prepend("Please Select","");
            $products=ProductConModel::join("unit",'unit.id','product.pro_unit_id')->select("product.*","unit.unit_name")->get();
            $blogs=DB::table("nso007_block")->join('nso007_project_stock',"nso007_block.project_id","nso007_project_stock.id")->select(DB::raw("CONCAT(nso007_project_stock.name,' | ',nso007_block.name) AS blog"),'nso007_block.id')->pluck('blog',"id")->prepend("Please Select","");
    
            return view('construction-stock.purchase.create',compact("suppliers","projects","products",'blogs','category','data','data_details','project_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        //delete
        $purchase_id = $id;
        $get_products = PurchaseStockModel::where("purchase_id",$purchase_id)->get();
        // dd($purchase_id);
        $get_purchase = PurchaseModel::find($purchase_id);
        if(!empty($get_products)&&count($get_products)>0&&!empty($get_purchase)){
            $can_delete = false;
            foreach($get_products as $get_product){
                $check_using = DB::table('nso007_product_stock')->where('product_id',$get_product->product_id)->where("balance_qty","<",$get_product->qty)->where('blog_id',$get_purchase->blog_id)->count();
                if($check_using>0){
                    $can_delete = true;
                }
            }
            if($can_delete==true){
                return \back()->with("warning","can't edit this record!");
            }
            else{
                foreach($get_products as $p_key=>$value){
                    #Decrease Product Stock
                    DB::table('nso007_product_stock')->where('product_id',$value->product_id)->where('blog_id',$get_purchase->blog_id)->update(['purchase_qty'=>DB::raw("purchase_qty - ".$value->qty),'balance_qty'=>DB::raw('balance_qty - '.$value->qty)]);
                    #Decrease Product
                    ProductConModel::where("id",$value->product_id)->update(["pro_qty"=>DB::raw('pro_qty - '.$value->qty)]);  
                }
                PurchaseStockModel::where("purchase_id",$purchase_id)->delete();//Delete Purchase Detail
                PurchaseModel::where("id",$purchase_id)->delete();//Delete Purchase 
            }
        }else{
            return \back()->with("warning","can't edit this record !");
        }
        //End

        //Store
        $this->validate($request,[
            'suppliers'     =>'required',
            'project'       =>'required',
            'purchase_date' =>'required',
            'product_code'  =>'required',
            'product_name'  =>'required',
            'product_price' =>'required',
            'product_qty'   =>'required',
            'blog_id'       =>'required',
            'invoice'       =>'required',
            'image.*' => 'mimes:jpeg,png,jpg,gif,svg|max:1024',
        ]);
        $supp       = $request->input("suppliers");
        $proj       = $request->input("project");
        $pur_date   = $request->input('purchase_date');
        $pro_code   = $request->input('product_code');
        $pro_name   = $request->input('product_name');
        $pro_price  = $request->input('product_price');
        $pro_qty    = $request->input('product_qty');
        $product_id = $request->input('product_id');
        $blog       = $request->input('blog_id');
        $invoice    = $request->input('invoice');

        $TotalCount=count($pro_code);
        $totalAmount=0;
        $purchase=new PurchaseModel;
        $purchase->date=date('Y-m-d');
        $purchase->date_purchase=date('Y-m-d',strtotime($pur_date));
        $purchase->blog_id=$blog;
        $purchase->supplier_id=$supp;
        $purchase->total_amount= $totalAmount;
        $purchase->invoice_num=$invoice;
        $purchase->person_recieve = $request->person_recieve;
        $purchase->save();
        $purchase_id=$purchase->id;

        if ($request->hasFile('image_invoice')) {
            $image_in = $request->file('image_invoice');
            foreach ($image_in as $key_in=>$files_in) {
                $destinationPath_invoice = public_path('/assets/img/upload');
                $file_name_invoice = "product-purchase".$key_in.time().".". $files_in->getClientOriginalExtension();
                $files_in->move($destinationPath_invoice, $file_name_invoice);
                DB::table("nso007_purchase_image")->insert(['image_name'=>$file_name_invoice,"purchase_id"=>$purchase_id]);
            }
        }

        for($i=0;$i<$TotalCount;$i++){
            $productqty=DB::table('product')->select('pro_qty')->where('id',$product_id[$i])->first();
            $product=ProductConModel::find($product_id[$i]);
            $product->pro_price=$pro_price[$i];
            $product->pro_qty=$productqty->pro_qty+$pro_qty[$i];
            $product->save();

            $pur_pro=DB::table('nso007_product_stock')->where('product_id',$product_id[$i])->where('blog_id',$blog)->select("*")->first();
            if(!empty($pur_pro)){
                DB::table('nso007_product_stock')->where('product_id',$product_id[$i])->where('blog_id',$blog)->update(['purchase_qty'=>($pur_pro->purchase_qty+$pro_qty[$i]),'balance_qty'=>($pur_pro->balance_qty+$pro_qty[$i])]);
            }else{
                DB::table('nso007_product_stock')->insert(['product_id'=>$product_id[$i],'blog_id'=>$blog,'purchase_qty'=>$pro_qty[$i],'balance_qty'=>$pro_qty[$i]]);
            }

            $totalAmount+=$pro_price[$i]*$pro_qty[$i];

            $purchase_stock=new PurchaseStockModel;
            $purchase_stock->purchase_id=$purchase_id;
            $purchase_stock->product_id=$product_id[$i];
            $purchase_stock->unit_price=$pro_price[$i];
            $purchase_stock->qty=$pro_qty[$i];
            $purchase_stock->amount=$pro_price[$i]*$pro_qty[$i];
            $purchase_stock->remark = $request->remark[$i];
            $purchase_stock->save();

            DB::table('product')->where("id",$product_id[$i])->update(['delete_status'=>1]);

            if ($request->hasFile($pro_code[$i])) {
                $image = $request->file($pro_code[$i]);
                foreach ($image as $key=>$files) {
                    $destinationPath = public_path('/assets/img/upload');
                    $file_name = "product-purchase".$key.time().".". $files->getClientOriginalExtension();
                    // $img = Image::make($files->getRealPath());
                    // $img->save($destinationPath.'/'.$file_name);
                    $files->move($destinationPath, $file_name);
                    DB::table("nso007_purchase_stock_image")->insert(['image_name'=>$file_name,"purchase_stock_id"=>$purchase_stock->id]);
                }
            }
        }
        $purchase_m=PurchaseModel::find($purchase_id);
        $purchase_m->total_amount= $totalAmount;
        $purchase_m->save();
        $last_purchase_id = PurchaseModel::max('id');
        $last_purchase = PurchaseModel::where('id',$last_purchase_id)->first();

        $supplier=DB::table('construction_supplier')->select("supp_name","supp_phone")->where("id",$supp)->first();
        //Accounting
        //End accouting
        return redirect()->route('purchases.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
