<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\CategoryModel;
use App\SubCategories;

class PaymentPolicyDetailController extends Controller
{
    public function index()
    {
        $data = DB::table("nso007_payment_policy_detail")
            ->leftjoin("nso007_payment_policy",'nso007_payment_policy_detail.policy_id','nso007_payment_policy.id')
            ->select('nso007_payment_policy_detail.id as policy_detail_id',
                     'nso007_payment_policy_detail.name as policy_detail_name',
                     'nso007_payment_policy_detail.description as policy_detail_description',
                     'nso007_payment_policy_detail.category_item_id',
                     'nso007_payment_policy_detail.sub_category_item_id',
                     'nso007_payment_policy.id as policy_id',
                     'nso007_payment_policy_detail.status',
                     'nso007_payment_policy.name as policy_name')
            ->get();
        $payment_policy = DB::table("nso007_payment_policy")
            ->select("id","name")
            ->pluck('name', 'id')
            ->prepend('Please Select', '');
        $data1="";
        if(!isset($data)) dd("OK");
        else
        {
            foreach($data as $key=>$value)
            {
                $categories_opt = "";$categories_data = "";
                if(!empty($value->category_item_id)){
                    $categories_data = explode('/',$value->category_item_id);
                    foreach($categories_data as $k=>$v){
                        $categories_opt .= optional(DB::table("nso007_category_stock")->where("id",$v)->first())->name;
                        if(isset($categories_data[$k+1])){
                            $categories_opt .= ", ";
                        }
                    }
                }

                $sub_categorys_opt = "";$sub_categorys_data = "";
                if(!empty($value->sub_category_item_id)){
                    $sub_categorys_data = explode('/',$value->sub_category_item_id);
                    foreach($sub_categorys_data as $i=>$val){
                        $sub_categorys_opt .= optional(DB::table("nso007_sub_category")->where("id",$val)->first())->name;
                        if(isset($sub_categorys_data[$i+1])){
                            $sub_categorys_opt .=", ";
                        }
                    }
                } 

                $button = "<a title='Edit' class='btn btn-sm btn-primary' href='".route('payment-policy-detail.edit',$value->policy_detail_id)."'><i class='fa fa-edit'></i></a>";

                if($value->status==0){
                    // $button .= "<button style='margin-left:10px;' title='Delete' class='btn btn-sm btn-danger' data-policy_id='".$value->policy_id."' data-id='".$value->policy_detail_id."' data-name='".$value->policy_detail_name."' data-description = '".$value->policy_detail_description."' onclick='delete_promotion_detail(this)'><i class='fa fa-trash'></i></button>";
                }
                $data1 .= "
                    <tr>
                        <td>".($key+1)."</td>
                        <td>".$value->policy_name."</td>
                        <td>".$value->policy_detail_name."</td>
                        <td>".$categories_opt."</td>
                        <td>".$sub_categorys_opt."</td>
                        <td>".$value->policy_detail_description."</td>
                        <td>".$button."</td>
                    </tr>";
            }
        }
        return view("setting.payment-policy-detail-index",["data"=>$data1,"payment_policy"=>$payment_policy]);
    }
    public function create(){
        $payment_policy = DB::table("nso007_payment_policy")
            ->select("id","name")
            ->pluck('name', 'id')
            ->prepend('Please Select', '');

        $categories = CategoryModel::select('name','id')
                      ->pluck('name', 'id');

        $sub_categories = SubCategories::select('name','id')
            ->pluck('name', 'id');

        return view("setting.create_payment_policy",["payment_policy"=>$payment_policy,'categories'=>$categories,'sub_categories'=>$sub_categories]);
    }
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required|unique:nso007_payment_policy_detail,name',
            'payment_policy'=>'required',
            'loan_generate_type'=>'required'
        ]);
        $categories = "";
        if(isset($request->category_id)&&!empty($request->category_id)&&count($request->category_id)>0){
            foreach($request->category_id as $key=>$category_id){
                $categories .= $category_id;
                if(isset($request->category_id[$key+1])){
                    $categories .= "/"; 
                }
            }
        }
        
        $sub_categories = "";
        if(isset($request->sub_category_id)&&!empty($request->sub_category_id)&&count($request->sub_category_id)>0){
            foreach($request->sub_category_id as $k=>$sub_category){
                $sub_categories .= $sub_category;
                if(isset($request->sub_category_id[$k+1])){
                    $sub_categories .= "/";
                }
            }
        }
        
        DB::table('nso007_payment_policy_detail')->insert(
            [
                'name'=>$request->name,
                'policy_id'=>$request->payment_policy,
                'category_item_id'=>$categories,
                'sub_category_item_id'=>$sub_categories,
                'loan_generate_type'=>$request->loan_generate_type
            ]
        );
        $insert_id = DB::table('nso007_payment_policy_detail')->max('id');
        if($request->loan_generate_type==1){
            $this->validate($request,[
                'percentage_of_amount'=>'required',
                'months_number'=>'required'
            ]);
            foreach($request->percentage_of_amount as $k=>$val){
                DB::table('nso007_payment_policy_detail_loan_without_interest')->insert(['month_number_th'=>($k+1),'percentage_of_amount'=>$val,'payment_policy_detail_id'=>$insert_id]);
            }
            
        }
        else if($request->loan_generate_type==2){
            $this->validate($request,[
                'loan_type'=>'required',
                'term'=>'required',
                'duration'=>'required',
                'interest'=>'required'
            ]);
            DB::table('nso007_payment_policy_detail_loan_with_interest')->insert(['loan_type'=>$request->loan_type,'term'=>$request->term,'duration'=>$request->duration,'interest'=>$request->interest,'status_change_interest'=>1,'payment_policy_detail_id'=>$insert_id]);
        }
        else if($request->loan_generate_type==3){
            $this->validate($request,[
                'loan_type'=>'required',
                'term'=>'required',
                'duration'=>'required',
                'interest'=>'required',
                'change_rate_from*'=>'required',
                'change_rate_to*'=>'required',
                'rate_condition*'=>'required'
            ]);
            DB::table('nso007_payment_policy_detail_loan_with_interest')->insert(['loan_type'=>$request->loan_type,'term'=>$request->term,'duration'=>$request->duration,'interest'=>$request->interest,'payment_policy_detail_id'=>$insert_id]);
            foreach($request->rate_condition as $key=>$value){
                DB::table('nso007_payment_policy_detail_loan_change_interest')->insert(['from_month'=>$request->change_rate_from[$key],'to_month'=>$request->change_rate_to[$key],'interest'=>$request->rate_condition[$key],'payment_policy_detail_id'=>$insert_id]);
            }
        }

        return redirect()->route("payment-policy-detail.index")->with("success","Payment Policy Detail Created !");
    }
    public function edit($id){
        $payment_policy = DB::table("nso007_payment_policy")
            ->select("id","name")
            ->pluck('name', 'id')
            ->prepend('Please Select', '');

        $categories = CategoryModel::select('name','id')
            ->pluck('name', 'id')
            ->prepend('Please Select', '');

        $sub_categories = SubCategories::select('name','id')
            ->pluck('name', 'id')
            ->prepend('Please Select', '');
        $data = DB::table('nso007_payment_policy_detail')->where("id",$id)->first();

        $categories_opt = [];$categories_data = "";
        if(!empty($data->category_item_id)){
            $categories_data = explode('/',$data->category_item_id);
            foreach($categories_data as $value){
                $categories_opt[] = $value;
            }
        }

        $sub_categorys_opt = [];$sub_categorys_data = "";
        if(!empty($data->sub_category_item_id)){
            $sub_categorys_data = explode('/',$data->sub_category_item_id);
            foreach($sub_categorys_data as $val){
                $sub_categorys_opt[] = $val;
            }
        }   

        return view("setting.edit_payment_policy",["payment_policy"=>$payment_policy,'categories'=>$categories,'sub_categories'=>$sub_categories,'data'=>$data,'categories_opt'=>$categories_opt,'sub_categorys_opt'=>$sub_categorys_opt]);
    }
    public function update(Request $request,$id)
    {
        
        $this->validate($request,[
            'name'=>'required|unique:nso007_payment_policy_detail,name,'.$id,
            'payment_policy'=>'required',
            'loan_generate_type'=>'required'
        ]);

        $categories = "";
        if(isset($request->category_id)&&!empty($request->category_id)&&count($request->category_id)>0){
            foreach($request->category_id as $key=>$category_id){
                $categories .= $category_id;
                if(isset($request->category_id[$key+1])){
                    $categories .= "/"; 
                }
            }
        }
        
        $sub_categories = "";
        if(isset($request->sub_category_id)&&!empty($request->sub_category_id)&&count($request->sub_category_id)>0){
            foreach($request->sub_category_id as $k=>$sub_category){
                $sub_categories .= $sub_category;
                if(isset($request->sub_category_id[$k+1])){
                    $sub_categories .= "/";
                }
            }
        }
        
        DB::table('nso007_payment_policy_detail')->where("id",$id)->update(
            [
                'name'=>$request->name,
                'policy_id'=>$request->payment_policy,
                'category_item_id'=>$categories,
                'sub_category_item_id'=>$sub_categories,
                'loan_generate_type'=>$request->loan_generate_type
            ]
        );
        
        $insert_id = $id;
        if($request->loan_generate_type==1){
            $this->validate($request,[
                'percentage_of_amount'=>'required',
                'months_number'=>'required'
            ]);
            DB::table('nso007_payment_policy_detail_loan_without_interest')->where('payment_policy_detail_id',$insert_id)->delete();
            foreach($request->percentage_of_amount as $k=>$val){
                DB::table('nso007_payment_policy_detail_loan_without_interest')->insert(['month_number_th'=>($k+1),'percentage_of_amount'=>$val,'payment_policy_detail_id'=>$insert_id]);
            }
            
        }
        else if($request->loan_generate_type==2){
            $this->validate($request,[
                'loan_type'=>'required',
                'term'=>'required',
                'duration'=>'required',
                'interest'=>'required'
            ]);
            DB::table('nso007_payment_policy_detail_loan_with_interest')->where('payment_policy_detail_id',$insert_id)->update(['loan_type'=>$request->loan_type,'term'=>$request->term,'duration'=>$request->duration,'interest'=>$request->interest,'status_change_interest'=>1,'payment_policy_detail_id'=>$insert_id]);
        }
        else if($request->loan_generate_type==3){
            $this->validate($request,[
                'loan_type'=>'required',
                'term'=>'required',
                'duration'=>'required',
                'interest'=>'required',
                'change_rate_from*'=>'required',
                'change_rate_to*'=>'required',
                'rate_condition*'=>'required'
            ]);

            DB::table('nso007_payment_policy_detail_loan_with_interest')->where('payment_policy_detail_id',$insert_id)->update(['loan_type'=>$request->loan_type,'term'=>$request->term,'duration'=>$request->duration,'interest'=>$request->interest,'payment_policy_detail_id'=>$insert_id]);

            DB::table('nso007_payment_policy_detail_loan_change_interest')->where('payment_policy_detail_id',$insert_id)->delete();
            foreach($request->rate_condition as $key=>$value){
                DB::table('nso007_payment_policy_detail_loan_change_interest')->insert(['from_month'=>$request->change_rate_from[$key],'to_month'=>$request->change_rate_to[$key],'interest'=>$request->rate_condition[$key],'payment_policy_detail_id'=>$insert_id]);
            }
        }

        return redirect()->route("payment-policy-detail.index")->with("success","Payment Policy Detail Updated !");
    }
    public function get_payment_policy_detail(Request $request){
        $data = DB::table("nso007_payment_policy_detail")->where("policy_id",$request->payment_policy_id)->select("id","name")->get();
        return json_encode($data);
    }
    // public function delete()
    // {
    //     $detail_id = $_GET['id'];
    //     DB::table('nso007_payment_policy_detail')->where("id",$detail_id)->where("status",0)->delete();

    //     \LogActivity::addToLog('Policy Payment Detail delete successfully!');

    // 	return redirect()->route("payment-policy-detail.index")->with("success","Payment Policy Detail deleted !");
    // }
    // public function get_sub_category(Request $request){
    //     $category_id = $request->category_id;
    //     $categories = DB::table('');
    // }
}
