<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountTypeModel;
use App\JournalModel;
use App\AccountChartModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use App\VoucherModel;
use Gate;
use Illuminate\Support\Facades\Session;

class JournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Journal-List', ['only' => ['index','get_journal']]);
         $this->middleware('permission:Journal-Create', ['only' => ['create','store']]);

         $this->middleware('permission:Journal-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Journal-Delete', ['only' => ['journal_confirm_delete']]);
         $this->middleware('permission:Journal-Print-Vourcher', ['only' => ['print_voucher']]);
    }
    public function index()
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(id," ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id')
            ->prepend('Please Select', '');
        return view('accounting.journal.index', ['acc_code' => $acc_code,'projects' => $projects]);
    }
    public function get_journal(Request $request)
    {
        if($request->isMethod('get')){
            $data = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
            ->select(
                'chart.acc_name',
                'chart.code as account_code',
                'jn.id',
                'jn.journal_des',
                'jn.journal_debit',
                'jn.journal_credit',
                'jn.journal_invoice',
                'jn.journal_paydate',
                'jn.journal_debit',
                'jn.journal_debit',
                'jn.journal_credit',
                'jn.voucher_type',
                'jn.voucher_ref',
                'jn.journal_status',
                'project.name as project_name',
                'jn.journal_tran_id as tran_id'
            )
                ->orderBy('jn.id','DESC')
            ->get();
        return DataTables::of($data)
            ->editColumn('id', '{{$tran_id}}')
            ->editColumn('voucher', function ($data) {
                $voucher = "";
                if ($data->voucher_type == 1) {
                    $voucher = "Cash Receipt";
                } else if ($data->voucher_type == 2) {
                    $voucher = "Cash Disbursement";
                } else if ($data->voucher_type == 3) {
                    $voucher = "Cash Reimbursement";
                } else if ($data->voucher_type == 4) {
                    $voucher = "Cash Advance";
                } else if ($data->voucher_type == 5) {
                    $voucher = "Advance Settlement";
                } else if ($data->voucher_type == 6) {
                    $voucher = "Journal Entry/Adjustment";
                }
                return $voucher;
            })
            ->editColumn('checkbox', function ($data) {
                return '<label><input id="' . $data->id . '" class="checkbox" type="checkbox"></label>';
            })
            ->editColumn('account_code', function ($data) {
                return $data->account_code . " " . $data->acc_name;
            })
            ->addColumn('action',function($data){
                $btn_edit = '';
                $btn_delete = '';
                if($data->journal_status==0){
                    if(Gate::check('Journal-Edit'))
                        $btn_edit.= '<a href="'.route('journal.edit',$data->id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                    if(Gate::check('Journal-Delete'))
                        $btn_delete.= '<a href="#" data-id="'.$data->id.'" data-toggle="modal" data-target="#form-delete" class="btn btn-sm btn-danger confirm_delete"><i class="fa fa-trash"></i></a>';
                }
                return $btn_edit.$btn_delete;
            })
            ->rawColumns(['checkbox' => 'checkbox', 'tran_id' => 'tran_id','action' => 'action'])
            ->make(true);
        }
        else{
            $from =  (empty($request->start_date))? '': date('Y-m-d',strtotime($request->start_date));
            $to =  (empty($request->end_date))? '': date('Y-m-d',strtotime($request->end_date));
            $ref =  (isset($request->ref) ? $request->ref : null);
            $project_id =  $request->project_id;
            $journal_code =  $request->journal_code;
            $data   = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart','chart.code','jn.journal_acccode')
            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
            ->select(
                'chart.acc_name',
                'chart.code as account_code',
                'jn.id',
                'jn.journal_des',
                DB::raw("IFNULL(jn.journal_des, '') AS journal_des"),
                'jn.journal_debit',
                'jn.journal_credit',
                'jn.journal_invoice',
                'jn.journal_paydate',
                'jn.journal_debit',
                'jn.journal_debit',
                'jn.journal_credit',
                'project.name as project_name',
                DB::raw('(CASE
                WHEN jn.voucher_type = "1" THEN "Cash Receipt"
                WHEN jn.voucher_type = "2" THEN "Cash Disbursement"
                WHEN jn.voucher_type = "3" THEN "Cash Reimbursement"
                WHEN jn.voucher_type = "4" THEN "Cash Advance"
                WHEN jn.voucher_type = "5" THEN "Advance Settlement"
                WHEN jn.voucher_type = "6" THEN "Journal Entry/Adjustment" END) AS voucher_type'),
                'jn.voucher_ref',
                'jn.journal_status',
                'jn.journal_tran_id as tran_id'
            )
            ->when($ref,function ($q) use($ref)
            {
                $q->where('jn.voucher_ref','LIKE','%'.$ref.'%');
            })
            ->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
            ->when(!empty($journal_code),function($q) use($journal_code){
                $q->where('jn.journal_acccode',$journal_code);
            })
            ->when(request('start_date',''),function($q) use($from, $to){
                $q->whereBetween('journal_paydate',[$from,$to]);
            })
            ->get();
            echo json_encode($data);
        }
    }
    public function note_print_date(Request $request)
    {
        $date = isset($request->date)?date("d-m-Y",strtotime($request->date)):date("d-m-Y");
        Session::put("date_print_journal",$date);
        return json_encode($date);
    }
    public function print_voucher(Request $request)
    {
        $voucher    = $request->voucher;
        $ArrVoucher = explode(",",$voucher);
        $data = array();
        foreach($ArrVoucher as $key => $journal_id){
            $journal = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart','chart.code','jn.journal_acccode')
            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
            ->select('chart.acc_name','project.name as project_name','chart.acc_namekh','jn.*')
            ->where('jn.id',$journal_id)
            ->first();
            if($journal){
                \array_push($data,$journal);
            }
        }
        return view('accounting.journal.report-print-voucher',['data'=>$data]);
    }

    public function create()
    {
        $acc_chart       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $max = JournalModel::max('journal_tran_id');
        $voucher_ref = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;
        $projects = ProjectModel::select(
            DB::raw('CONCAT(id," ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id')
            ->prepend('Please Select', '');
        return view('accounting.journal.create', ['acc_chart' => $acc_chart, 'projects' => $projects, 'voucher_ref' => $voucher_ref]);
    }
    public function query_account_code(Request $request)
    {
        $account_code = $request->obj;
        $account_chart = AccountChartModel::where('acctype',$account_code)->get();
        echo \json_encode($account_chart);
    }

    public function store(Request $request)
    {
        $project_id = null;
        $this->validate($request, [
            'date'          => 'required',
            'voucher_type'  => 'required',
            'voucher_ref'   => 'required',
            'acc_chart'      => 'required',
//            'account_code'  => 'required',
            'ref_number'    => 'required',
            'debit'         => 'required',
            'credit'        => 'required'
        ]);
        $max_id             = JournalModel::max('id');
        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;
        // dd($journal_tran_id);
        $date = date('Y-m-d', strtotime($request->date));
        if (!$max_id) {
            $max_id     =   0;
        }
        $parent_id      = $max_id + 1;
        $acc_code = [];
        $account_type = [];
        $voucher_ref = \Globals::voucher_ref();
        foreach ($request->acc_chart as $key => $type) {
            $acc_type=AccountChartModel::where('code',$request->acc_chart[$key])->first();

            $type_id=AccountTypeModel::find($acc_type->type_id);
            if ($key ==  0) {
                JournalModel::insert([
                    'journal_parentid'          => 0,
                    'journal_type'              => $type_id->id,
                    'journal_acccode'           => $request->acc_chart[$key],
                    'voucher_type'              => $request->voucher_type,
                    'voucher_ref'               => $request->voucher_ref,
                    'journal_des'               => $request->description,
                    'journal_debit'             => $request->debit[$key],
                    'journal_credit'            => $request->credit[$key],
                    'journal_paydate'           => $date,
                    'journal_by'                => Auth::user()->id,
                    'journal_invoice'           => $request->ref_number[$key],
                    'journal_transactiondate'   => date('Y-m-d H:i:s'),
                    'journal_tran_id'           => $journal_tran_id,
                    'journal_by_project'        => $request->journal_by_project,
                    'journal_status'           => 0
                ]);
            }
            else if ($key > 0) {
                JournalModel::insert([
                    'journal_parentid'          => $parent_id,
                    'journal_type'              => $type_id->id,
                    'journal_acccode'           => $request->acc_chart[$key],
                    'voucher_type'              => $request->voucher_type,
                    'voucher_ref'               => $request->voucher_ref,
                    'journal_des'               => $request->description,
                    'journal_debit'             => $request->debit[$key],
                    'journal_credit'            => $request->credit[$key],
                    'journal_paydate'           => $date,
                    'journal_by'                => Auth::user()->id,
                    'journal_invoice'           => $request->ref_number[$key],
                    'journal_transactiondate'   => date('Y-m-d H:i:s'),
                    'journal_tran_id'           => $journal_tran_id,
                    'journal_by_project'        => $request->journal_by_project,
                    'journal_status'           => 0
                ]);
            } else {
                break;
            }
        }
        return redirect()->route('journal.index')->with('success', 'Journal Added Successfully');
    }


    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // dd($id);
        $journal = JournalModel::where(function($query) use($id){
            $jn = JournalModel::find($id);
            $query->where('journal_tran_id',$jn->journal_tran_id);
        })->orderBy('id','asc')->get();
        $voucher = VoucherModel::pluck('name', 'id')->prepend('Please Select', '');
        $acc_chart       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');

        $projects = ProjectModel::select(
            DB::raw('CONCAT(id," ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id')
            ->prepend('Please Select', '');
        return view('accounting.journal.edit',compact('projects','journal','voucher','acc_chart'));
    }

    public function update(Request $request, $id)
    {
        // dd($request->all());
        $journal_id = $request->journal_id;
        $ids = [];
        $preID = null;
        $acc_code = [];
        foreach($journal_id as $jn_id){
            if(!empty($jn_id)){
                array_push($ids,$jn_id);
            }
        }

        foreach($journal_id as $i => $jn_id){
            $acc_type=AccountChartModel::where('code',$request->acc_chart[$i])->first();

            $type_id=AccountTypeModel::find($acc_type->type_id);
            if(!empty($jn_id))
            {
                if($i==0){
                    $preID = $jn_id;
                }
                JournalModel::where('id',$jn_id)->update([
                    'journal_acccode'=> $request->acc_chart[$i],
                    'voucher_type'=> $request->voucher_type,
                    'voucher_ref'=>$request->voucher_ref,
                    'journal_type'=> $type_id->id,
                    'journal_des'=> $request->journal_des,
                    'journal_debit'=>$request->debit[$i],
                    'journal_credit'=> $request->credit[$i],
                    'journal_paydate'=>date('Y-m-d',strtotime($request->journal_paydate)),
                    'journal_by_project'        => $request->journal_by_project,
                    'journal_invoice'=> $request->ref_number[$i],
                    'journal_status' => 0
                ]);
            }
            else
            {
                JournalModel::insert([
                    'journal_parentid'=> JournalModel::find($preID)->id,
                    'journal_acccode '=> $request->acc_chart[$i],
                    'voucher_type'=> $request->voucher_type,
                    'voucher_ref'=>$request->voucher_ref,
                    'journal_type'=> $type_id->id,
                    'journal_des'=> $request->journal_des,
                    'journal_debit'=>$request->debit[$i],
                    'journal_credit'=> $request->credit[$i],
                    'journal_paydate'=>date('Y-m-d',strtotime($request->journal_paydate)),
                    'journal_by_project'        => $request->journal_by_project,
                    'journal_invoice'=> $request->ref_number[$i],
                    'journal_status'=>0,
                    'journal_tran_id'=> JournalModel::find($preID)->journal_tran_id
                ]);
            }

        }
        return redirect()->route('journal.index')->with('success','Journal Successfully Updated');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function journal_confirm_delete(Request $request)
    {
        $id = $request->delete_id;
        JournalModel::where(function($query) use($id){
            $jn = JournalModel::find($id);
            $query->where('journal_tran_id',$jn->journal_tran_id);
        })->delete();
        return response()->json(['success' => true,'message' => 'Journal Delete Successfully']);
    }
}
