<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\JournalModel;
use App\AccountChartModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use Gate;

class IncomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct(){
        $this->middleware('permission:Add-Income', ['only' => ['create','store']]);
        $this->middleware('permission:List-Income', ['only' => ['index']]);
        $this->middleware('permission:Edit-Income', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete-Income', ['only' => ['delete']]);
    }
    public function index(Request $request)
    {

        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $last_months = $request->last_months;
                $voucher_ref = $request->voucher_ref;
                $journal_acccode = $request->journal_acccode;
                if($request->type_cash==2){
                    $count_total = DB::table('nso007_journal as jn')
                                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                    ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                    ->select(
                                        'chart.acc_name',
                                        'chart.code as account_code',
                                        'jn.id',
                                        'jn.journal_des',
                                        'jn.journal_debit',
                                        'jn.journal_credit',
                                        'jn.journal_invoice',
                                        'jn.journal_paydate',
                                        'jn.voucher_type',
                                        'jn.voucher_ref',
                                        'jn.journal_status',
                                        'project.name as project_name',
                                        'jn.journal_tran_id as tran_id'
                                    )
                                    ->where("jn.journal_status","!=",3)
                                    ->where("jn.journal_debit",">",0)
                                    ->whereIn("jn.journal_acccode",['11001','11002'])
                                    ->orderBy("jn.journal_paydate","DESC")
                                    ->count();
                    $count_filter = DB::table('nso007_journal as jn')
                                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                    ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                    ->select(
                                        'chart.acc_name',
                                        'chart.code as account_code',
                                        'jn.id',
                                        'jn.journal_des',
                                        'jn.journal_debit',
                                        'jn.journal_credit',
                                        'jn.journal_invoice',
                                        'jn.journal_paydate',
                                        'jn.voucher_type',
                                        'jn.voucher_ref',
                                        'jn.journal_status',
                                        'project.name as project_name',
                                        'jn.journal_tran_id as tran_id'
                                    )
                                    ->where("jn.journal_status","!=",3)
                                    ->where("jn.journal_debit",">",0)
                                    ->whereIn("jn.journal_acccode",['11001','11002'])
                                    ->where(function($query) use ($project_id){
                                        if(!empty($project_id)){
                                            $query->whereIn("jn.journal_by_project",$project_id);
                                        }
                                    })
                                    ->where(function($query) use ($start_date,$end_date){
                                        if(!empty($start_date)&&!empty($end_date)){
                                            $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                        }
                                    })
                                    ->where(function($query) use ($last_months){
                                        if(!empty($last_months)){
                                            $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                        }
                                    })
                                    ->where(function($query) use ($voucher_ref){
                                        if(!empty($voucher_ref)){
                                            $query->where("jn.voucher_ref",$voucher_ref);
                                        }
                                    })
                                    ->where(function($query) use ($journal_acccode){
                                        if(!empty($journal_acccode)){
                                            $query->whereIn("jn.journal_acccode",$journal_acccode);
                                        }
                                    })
                                    ->orderBy("jn.journal_paydate","DESC")
                                    ->count();
                    $data = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("jn.journal_status","!=",3)
                                ->where("jn.journal_debit",">",0)
                                ->whereIn("jn.journal_acccode",['11001','11002'])
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id))
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->orderBy("jn.journal_paydate","DESC")
                                ->take(20);
                                return DataTables::of($data)
                                    ->addIndexColumn()
                                    ->with([
                                        "recordsTotal" => $count_total,
                                        "recordsFiltered" => $count_filter,
                                    ])
                                    ->editColumn('voucher', function ($data) {
                                        $voucher = "";
                                        if ($data->voucher_type == 1) {
                                            $voucher = "Cash Receipt";
                                        } else if ($data->voucher_type == 2) {
                                            $voucher = "Cash Disbursement";
                                        } else if ($data->voucher_type == 3) {
                                            $voucher = "Cash Reimbursement";
                                        } else if ($data->voucher_type == 4) {
                                            $voucher = "Cash Advance";
                                        } else if ($data->voucher_type == 5) {
                                            $voucher = "Advance Settlement";
                                        } else if ($data->voucher_type == 6) {
                                            $voucher = "Journal Entry/Adjustment";
                                        }
                                        return $voucher;
                                    })
                                    ->editColumn('account_code', function ($data) {
                                        return $data->account_code . " " . $data->acc_name;
                                    })
                                    ->editColumn('journal_credit',function($data){
                                        return "$".number_format($data->journal_debit-$data->journal_credit,2);
                                    })
                                    ->editColumn('journal_paydate',function($data){
                                        return date("d-m-Y",strtotime($data->journal_paydate));
                                    })
                                    ->addColumn('action',function($data){
                                        $btn_edit = '';
                                        $btn_delete = '';
                                        if($data->journal_status==0){
                                            if(Gate::check('Edit-Income'))
                                                $btn_edit.= '<a href="'.route('income.edit',$data->tran_id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                                            if(Gate::check('Delete-Income'))
                                                $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->tran_id.'" onclick="delete_income('.$data->tran_id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                                        }
                                        return $btn_edit.$btn_delete;
                                    })
                                    ->rawColumns(['action' => 'action'])
                                    ->make(true);
                }
                else{
                    $count_total = DB::table('nso007_journal as jn')
                                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                    ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                    ->select(
                                        'chart.acc_name',
                                        'chart.code as account_code',
                                        'jn.id',
                                        'jn.journal_des',
                                        'jn.journal_debit',
                                        'jn.journal_credit',
                                        'jn.journal_invoice',
                                        'jn.journal_paydate',
                                        'jn.voucher_type',
                                        'jn.voucher_ref',
                                        'jn.journal_status',
                                        'project.name as project_name',
                                        'jn.journal_tran_id as tran_id'
                                    )
                                    ->where("journal_status","!=",3)
                                    ->where("journal_acccode","LIKE","4%")
                                    ->orderBy("jn.journal_paydate","DESC")
                                    ->count();
                    $count_filter = DB::table('nso007_journal as jn')
                                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                    ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                    ->select(
                                        'chart.acc_name',
                                        'chart.code as account_code',
                                        'jn.id',
                                        'jn.journal_des',
                                        'jn.journal_debit',
                                        'jn.journal_credit',
                                        'jn.journal_invoice',
                                        'jn.journal_paydate',
                                        'jn.voucher_type',
                                        'jn.voucher_ref',
                                        'jn.journal_status',
                                        'project.name as project_name',
                                        'jn.journal_tran_id as tran_id'
                                    )
                                    ->where("journal_status","!=",3)
                                    ->where("journal_acccode","LIKE","4%")
                                    ->where(function($query) use ($project_id){
                                        if(!empty($project_id)){
                                            $query->whereIn("jn.journal_by_project",$project_id);
                                        }
                                    })
                                    ->where(function($query) use ($start_date,$end_date){
                                        if(!empty($start_date)&&!empty($end_date)){
                                            $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                        }
                                    })
                                    ->where(function($query) use ($last_months){
                                        if(!empty($last_months)){
                                            $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                        }
                                    })
                                    ->where(function($query) use ($voucher_ref){
                                        if(!empty($voucher_ref)){
                                            $query->where("jn.voucher_ref",$voucher_ref);
                                        }
                                    })
                                    ->where(function($query) use ($journal_acccode){
                                        if(!empty($journal_acccode)){
                                            $query->whereIn("jn.journal_acccode",$journal_acccode);
                                        }
                                    })
                                    ->orderBy("jn.journal_paydate","DESC")
                                    ->count();
                    $data = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status","!=",3)
                                ->where("journal_acccode","LIKE","4%")
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id))
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->orderBy("jn.journal_paydate","DESC")
                                ->take(20);
                                return DataTables::of($data)
                                    ->addIndexColumn()
                                    ->with([
                                        "recordsTotal" => $count_total,
                                        "recordsFiltered" => $count_filter,
                                    ])
                                    ->editColumn('voucher', function ($data) {
                                        $voucher = "";
                                        if ($data->voucher_type == 1) {
                                            $voucher = "Cash Receipt";
                                        } else if ($data->voucher_type == 2) {
                                            $voucher = "Cash Disbursement";
                                        } else if ($data->voucher_type == 3) {
                                            $voucher = "Cash Reimbursement";
                                        } else if ($data->voucher_type == 4) {
                                            $voucher = "Cash Advance";
                                        } else if ($data->voucher_type == 5) {
                                            $voucher = "Advance Settlement";
                                        } else if ($data->voucher_type == 6) {
                                            $voucher = "Journal Entry/Adjustment";
                                        }
                                        return $voucher;
                                    })
                                    ->editColumn('account_code', function ($data) {
                                        return $data->account_code . " " . $data->acc_name;
                                    })
                                    ->editColumn('journal_credit',function($data){
                                        return "$".number_format($data->journal_credit-$data->journal_debit,2);
                                    })
                                    ->editColumn('journal_paydate',function($data){
                                        return date("d-m-Y",strtotime($data->journal_paydate));
                                    })
                                    ->addColumn('action',function($data){
                                        $btn_edit = '';
                                        $btn_delete = '';
                                        if($data->journal_status==0){
                                            if(Gate::check('Edit-Income'))
                                                $btn_edit.= '<a href="'.route('income.edit',$data->tran_id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                                            if(Gate::check('Delete-Income'))
                                                $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->tran_id.'" onclick="delete_income('.$data->tran_id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                                        }
                                        return $btn_edit.$btn_delete;
                                    })
                                    ->rawColumns(['action' => 'action'])
                                    ->make(true);
                }

            }
        }
        return view('accounting.income.index', ['acc_code' => $acc_code,'projects' => $projects]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('accounting.income.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required',
            'cash_type'=>'required'
        ]);

        $max            = JournalModel::max('journal_tran_id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        $income = new JournalModel;
        $income->journal_parentid = 0;
        $income->journal_type = 40000;
        $income->journal_acccode = $request->journal_acccode;
        $income->voucher_type = 1;
        $income->voucher_ref = $voucher_ref;
        $income->journal_des = $request->description;
        $income->journal_debit = 0;
        $income->journal_credit = $request->amount;
        $income->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $income->journal_by = Auth::user()->id;
        $income->journal_transactiondate = date('Y-m-d H:i:s');
        $income->journal_tran_id = $journal_tran_id;
        $income->journal_by_project = $request->journal_by_project;
        $income->journal_status= 0;
        $income->person_name = $request->person_name;
        $income->transaction_type = "Acc-Income";
        $income->ref_account_chart = $request->journal_acccode;
        $income->save();

        $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();
        $cash = new JournalModel;
        $cash->journal_parentid = $jj->last_id;
        $cash->journal_type = 10000;
        $cash->journal_acccode = $request->cash_type;
        $cash->voucher_type = 1;
        $cash->voucher_ref = $voucher_ref;
        $cash->journal_des = $request->description;
        $cash->journal_debit = $request->amount;
        $cash->journal_credit = 0;
        $cash->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $cash->journal_by = Auth::user()->id;
        $cash->journal_transactiondate = date('Y-m-d H:i:s');
        $cash->journal_tran_id = $journal_tran_id;
        $cash->journal_by_project = $request->journal_by_project;
        $cash->journal_status= 0;
        $cash->person_name = $request->person_name;
        $cash->transaction_type = "Acc-Income";
        $cash->ref_account_chart = $request->journal_acccode;
        $cash->save();

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('income.index')->with("success","Create Successfully!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = JournalModel::where("journal_tran_id",$id)->where("journal_acccode","LIKE","4%")->first();
        $cash_type = JournalModel::where("journal_type",10000)->where("journal_tran_id",$data->journal_tran_id)->first();
        return view('accounting.income.edit',compact('data','cash_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'journal_acccode'   =>'required',
            'journal_by_project'=>'required',
            'journal_paydate'   =>'required',
            'journal_credit'    =>'required',
            "cash_type"         =>'required',
            "cash_id"           =>'required'
        ]);
        $journal = JournalModel::find($id);

        JournalModel::where("id",$id)->update([
            'journal_acccode'           => $request->journal_acccode,
            'journal_des'               => $request->description,
            'journal_credit'            => $request->journal_credit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'person_name'               =>$request->person_name,
            'transaction_type'          => "Acc-Income",
            'ref_account_chart'         =>$request->journal_acccode,
        ]);

        JournalModel::where("id",$request->cash_id)->update([
            'journal_acccode'           => $request->cash_type,
            'journal_des'               => $request->description,
            'journal_debit'            => $request->journal_credit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'person_name'              =>$request->person_name,
            'transaction_type'         => "Acc-Income",
            'ref_account_chart'        =>$request->journal_acccode,
        ]);
        if(!empty($journal->journal_referenceid)){
            $receiv  = JournalModel::where('id',$journal->journal_referenceid)->first();
            $receivpaid = $receiv->receiveable_paid - $journal->journal_credit + $request->journal_credit;
            JournalModel::where("id",$id)->update([
                'journal_acccode'           => $request->journal_acccode,
                'journal_des'               => $request->description,
                'journal_credit'            => $request->journal_credit,
                'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
                'journal_by_project'        => $request->journal_by_project,
                'person_name'               =>$request->person_name,
                'transaction_type'          => "Acc-Income",
                'ref_account_chart'         =>$request->journal_acccode,
            ]);
    
            JournalModel::where("id",$request->cash_id)->update([
                'journal_acccode'           => $request->cash_type,
                'journal_des'               => $request->description,
                'journal_debit'            => $request->journal_credit,
                'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
                'journal_by_project'        => $request->journal_by_project,
                'person_name'              =>$request->person_name,
                'transaction_type'         => "Acc-Income",
                'ref_account_chart'        =>$request->journal_acccode,
            ]);
            JournalModel::where("id",$journal->journal_referenceid)->update([
                'receiveable_paid'          => $receivpaid,
            ]);
        }
        


        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('income.index')->with("success","Update Successfully!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function delete()
    {
        $journal_id = $_GET['id'];
        $delete = JournalModel::where("journal_tran_id",$journal_id)->get();
        foreach($delete as $del){
            if(!empty($del->journal_referenceid)){
                $receiv  = JournalModel::where('id',$del->journal_referenceid)->first();
                $receivpaid = $receiv->receiveable_paid - $del->journal_credit;
                JournalModel::where("id",$del->journal_referenceid)->update([
                    'receiveable_paid'          => $receivpaid,
                ]); 
            }
            $del->delete();
            if($receivpaid == 0 ){
                JournalModel::where("id",$del->journal_referenceid)->update([
                    'delete_status'          => 1,
                ]); 
            }
           
        }
        return redirect()->route('income.index')->with("success","Delete Successfully!");
    }
    public function store_sub_account(){

    }
}
