<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Helpers\IString;
use App\Models\Hr\EmpLeave;
use App\Models\Hr\EmpLeaveDetail;
use App\Models\Hr\Employee;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\LeaveType;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class TakeLeaveAuthorizeController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Take Leave Authorize List', ['only' => ['index']]);
        $this->middleware('permission:Take Leave Authorize Create', ['only' => ['create','store']]);
        $this->middleware('permission:Take Leave Authorize Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Take Leave Authorize Status', ['only' => ['change_status']]);
        $this->middleware('permission:Take Leave Authorize Approve', ['only' => ['review']]);
        $this->middleware('permission:Take Leave Authorize Show');
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $r = EmpLeave::where('review', 1)->take(20);
            return Datatables::of($r)
                            ->addIndexColumn()
                            ->editColumn('emp_id',function ($d){
                                return optional(User::find($d->emp_id))->english_name;
                            })
                            ->editColumn('request_to',function ($d){
                                return optional(User::find($d->request_to))->english_name;
                            })
                            ->editColumn('leave_type', function($data){
                                return IString::getUpperCaseCharacter(optional($data->leave_typee)->name);
                            })
                            ->editColumn('from_date', function($data){
                                return $data->from_date ? date('d-m-Y', strtotime($data->from_date)) : "";
                            })
                            ->editColumn('to_date', function($data){
                                return $data->to_date ? date('d-m-Y', strtotime($data->to_date)) : "";
                            })
                            ->editColumn('request_date', function($data){
                                return $data->request_date ? date('d-m-Y', strtotime($data->request_date)) : "";
                            })
                            ->editColumn('review', function($data){
                                $review  = $data->review?$data->review: "";
                                if($review == 0)
                                {
                                    $status = '<small class="text-primary">pending</small>';

                                }elseif($review == 1){
                                    $status = '<small class="text-success">approved</small>';

                                }elseif($review == 2){
                                    $status = '<small class="text-danger">rejected</small>';
                                }

                                return $status;

                            })
                            ->editColumn('approve', function($data){
                                $approve  = $data->approve?$data->approve: "";
                                if($approve == 0)
                                {
                                    $status = '<small class="text-primary">pending</small>';

                                }elseif($approve == 1){
                                    $status = '<small class="text-success">approved</small>';

                                }elseif($approve == 2){
                                    $status = '<small class="text-danger">rejected</small>';
                                }

                                return $status;

                            })
                            ->addColumn('action' ,function($data){
                                $check_language = Fun::lang();

                                if ($check_language == 'km') {
                                    $status = "ស្ថានភាព";
                                    $view = "បង្ហាញ";
                                    $delete = "លុបចោល";
                                    $deduct​ = "កាត់លុយ";
                                }else{
                                    $status = "Status";
                                    $view = "View";
                                    $delete = "Delete";
                                    $deduct​ = "Deduct";
                                }
                                $btn = '';
                                if(Gate::check('Take Leave Authorize Status')) {
                                    if ($data->approve == 0) {
                                        $btn .= '<a class="btn btn-sm btn-danger btn_status_authorize" title="' . $status . '" data-id="' . $data->id . '"><span class="fa fa-spinner"></span> Approve</a>&nbsp;';
                                    }
                                }
                                if(Gate::check('Take Leave Authorize Show')) {
                                    $btn .= '<a class="btn btn-sm btn-info" href="' . route('take-leave-form', encrypt($data->id)) . '" target="_blank"  title="' . $view . '"><span class="fa fa-eye"></span> View</a>&nbsp;';
                                }
                                if(Gate::check('Take Leave Authorize Approve')) {
                                    $btn .= '<a class="btn btn-sm btn-warning btn_deduct" title="' . $deduct​ . '" data-id="' . $data->id . '"><span class="fa fa-dollar-sign"></span> Deduct</a>&nbsp;';
                                }

                                return $btn;
                            })
                            ->rawColumns(['action' => 'action', 'review' => 'review', 'approve' => 'approve'])
                            ->make(true);
        }
        return view('hr.take-leave-authorize.index');
    }

    public function create()
    {
        $job = Employee::pluck('name', 'id');
        return view('hr.take-leave-authorize.create', compact('job'));

    }

    public function store(Request $r)
    {

        EmpLeave::saveDetail( null, $r);
        return redirect('take-leave-authorize')->with('success', 'Employee leave success full');
    }

    public function show($id)
    {

    }

    public function edit($id)
    {
        $d = EmpLeave::find($id);
        return view('hr.take-leave-authorize.create', compact('d'));
    }

    public function update(Request $r, $id)
    {
        EmpLeave::saveDetail( $id, $r);
        return redirect('take-leave-authorize')->with('success', 'Employee leave success full');
    }

    public function destroy($id)
    {

        $d = EmpLeave::findOrFail($id);
        $d->delete();

        return redirect('take-leave-authorize')->with('success', 'Employee leave is successfully deleted');
    }

    function delete($id)
    {
        EmpLeave::find($id)->delete();
        return response()->json([
            'success' => true,
            'message' => 'Employee leave is successfully deleted'
        ]);
    }

    function review($id)
    {
        EmpLeave::saveReview($id);
        $emp_leave = EmpLeave::find($id);
        $emp = Employee::pluck('name', 'id');
        $leave_type = LeaveType::pluck('name','id');
        return view('hr.take-leave-authorize.review', compact('leave_type','emp_leave', 'emp'));
    }

    function approve(Request $request, $id)
    {
        $approve = $request->approve;
        $emp_leave = EmpLeave::find($id);
        $emp_leave_detail = EmpLeaveDetail::where('emp_leave_id',$id)->get();

        if($emp_leave){
            $emp_leave->approve = $approve;
            $emp_leave->save();
        }
        foreach ($emp_leave_detail as $row){
            $row->approve = $approve;
            $row->save();
        }

        return redirect('take-leave-authorize')->with('success', 'Employee leave is successfully updated');

    }
    public function change_status(Request $request)
    {
        $id         = $request->id;
        $status     = $request->status;
        EmpLeave::where('id', $id)->update(['approve' => $status]);
        //EmpLeaveDetail::where('emp_leave_id',$id)->update(['approve' => $status]);
        return redirect('take-leave-authorize')->with('success', 'Employee leave is Changed successfully');
    }

    public function deduct_status(Request $request)
    {
        $id         = $request->ids;
        $deduct     = $request->deduct;
        EmpLeave::where('id', $id)->update(['deduct' => $deduct]);
        //EmpLeaveDetail::where('emp_leave_id',$id)->update(['deduct' => $deduct]);
        return redirect('take-leave-authorize')->with('success', 'Employee updated successfully');
    }
}
