<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\SalaryTaxModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class SalaryTaxController extends Controller
{


    function __construct()
    {
        $this->middleware('permission:Salary tax List', ['only' => ['index']]);
        $this->middleware('permission:Salary tax Create', ['only' => ['create','store']]);
        $this->middleware('permission:Salary tax Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Salary tax Delete', ['only' => ['delete_salary_tax']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = SalaryTaxModel::orderBy('id', 'DESC')->take(20);
            return DataTables::of($data)
                        ->addIndexColumn()
                        ->addColumn('action', function($data){
                            $btn_edit="";
                            $btn_delete="";
                            if(Gate::check('Salary tax Edit')){
                                $btn_edit .= '<a href="'.route('salary-tax.edit', encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                            }
                            if(Gate::check('Salary tax Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_edit.$btn_delete;
                        })
                        ->addColumn('rate', function($data){
                            $rate_zero       = $data->rate_zero;
                            $rate_five       = $data->rate_five;
                            $rate_ten        = $data->rate_ten;
                            $rate_fifteen    = $data->rate_fifteen;
                            $rate_twenty     = $data->rate_twenty;

                            return $rate_zero.' / '.$rate_five.' / '.$rate_ten.' / '.$rate_fifteen.' / '.$rate_twenty;
                        })
                        ->addColumn('from_salary', function($data){
                            $from_salary_zero       = number_format($data->from_salary_zero);
                            $from_salary_five       = number_format($data->from_salary_five);
                            $from_salary_ten        = number_format($data->from_salary_ten);
                            $from_salary_fifteen    = number_format($data->from_salary_fifteen);

                            return $from_salary_zero.' / '.$from_salary_five.' / '.$from_salary_ten.' / '.$from_salary_fifteen;
                        })
                        ->addColumn('to_salary', function($data){
                            $to_salary_zero       = number_format($data->to_salary_zero);
                            $to_salary_five       = number_format($data->to_salary_five);
                            $to_salary_ten        = number_format($data->to_salary_ten);
                            $to_salary_fifteen    = number_format($data->to_salary_fifteen);

                            return $to_salary_zero.' / '.$to_salary_five.' / '.$to_salary_ten.' / '.$to_salary_fifteen;
                        })
                        ->rawColumns(['action', 'rate', 'from_salary', 'to_salary'])
                        ->make(true);
        }
        return view('hr.salary-tax.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.salary-tax.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'name'                  => 'required',
            'rate_zero'             => 'required',
            'from_salary_zero'      => 'required',
            'to_salary_zero'        => 'required',

            'rate_five'             => 'required',
            'from_salary_five'      => 'required',
            'to_salary_five'        => 'required',

            'rate_ten'              => 'required',
            'from_salary_ten'       => 'required',
            'to_salary_ten'         => 'required',

            'rate_fifteen'          => 'required',
            'from_salary_fifteen'   => 'required',
            'to_salary_fifteen'     => 'required',

            'rate_twenty'           => 'required',
            'over_twenty'           => 'required',
        ]);


        $salary_tax                         = new SalaryTaxModel();
        $salary_tax->name                   = $request->name;

        $salary_tax->rate_zero              = $request->rate_zero;
        $salary_tax->from_salary_zero       = $request->from_salary_zero;
        $salary_tax->to_salary_zero         = $request->to_salary_zero;

        $salary_tax->rate_five              = $request->rate_five;
        $salary_tax->from_salary_five       = $request->from_salary_five;
        $salary_tax->to_salary_five         = $request->to_salary_five;

        $salary_tax->rate_ten               = $request->rate_ten;
        $salary_tax->from_salary_ten        = $request->from_salary_ten;
        $salary_tax->to_salary_ten          = $request->to_salary_ten;

        $salary_tax->rate_fifteen           = $request->rate_fifteen;
        $salary_tax->from_salary_fifteen    = $request->from_salary_fifteen;
        $salary_tax->to_salary_fifteen      = $request->to_salary_fifteen;

        $salary_tax->rate_twenty            = $request->rate_twenty;
        $salary_tax->over_twenty            = $request->over_twenty;

        $salary_tax->save();


        return redirect()->route('salary-tax.index')->with('succes', 'Data was added successful!');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $salary_tax = SalaryTaxModel::findOrFail($id);
        return view('hr.salary-tax.edit', compact('salary_tax'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'name'          => 'required',
            'rate_zero'             => 'required',
            'from_salary_zero'      => 'required',
            'to_salary_zero'        => 'required',

            'rate_five'             => 'required',
            'from_salary_five'      => 'required',
            'to_salary_five'        => 'required',

            'rate_ten'              => 'required',
            'from_salary_ten'       => 'required',
            'to_salary_ten'         => 'required',

            'rate_fifteen'          => 'required',
            'from_salary_fifteen'   => 'required',
            'to_salary_fifteen'     => 'required',

            'rate_twenty'           => 'required',
            'over_twenty'           => 'required',
        ]);



        $salary_tax                         = SalaryTaxModel::findOrFail($id);
        $salary_tax->name                   = $request->name;

        $salary_tax->rate_zero              = $request->rate_zero;
        $salary_tax->from_salary_zero       = $request->from_salary_zero;
        $salary_tax->to_salary_zero         = $request->to_salary_zero;

        $salary_tax->rate_five              = $request->rate_five;
        $salary_tax->from_salary_five       = $request->from_salary_five;
        $salary_tax->to_salary_five         = $request->to_salary_five;

        $salary_tax->rate_ten               = $request->rate_ten;
        $salary_tax->from_salary_ten        = $request->from_salary_ten;
        $salary_tax->to_salary_ten          = $request->to_salary_ten;

        $salary_tax->rate_fifteen           = $request->rate_fifteen;
        $salary_tax->from_salary_fifteen    = $request->from_salary_fifteen;
        $salary_tax->to_salary_fifteen      = $request->to_salary_fifteen;

        $salary_tax->rate_twenty            = $request->rate_twenty;
        $salary_tax->over_twenty            = $request->over_twenty;

        $salary_tax->update();


        return redirect()->route('salary-tax.index')->with('succes', 'Data was updated successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //delete salary tax
    public function delete_salary_tax(Request $request)
    {

        $id = $request->delete_id;
        SalaryTaxModel::where('id', $id)->delete();
        return redirect()->route('salary-tax.index')->with('succes', 'Data was deleted successful!');

    }
}
