<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\Employee;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrPositionModel;
use Yajra\DataTables\DataTables;
use App\User;
use Illuminate\Support\Facades\DB;

class ReportEmployeeController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Employee Report List', ['only' => ['index','employeeList','get_report_employee']]);
        $this->middleware('permission:Report Employee Branch', ['only' => ['get_employee_by_branch','get_report_employee_by_branch']]);
    }
    public function index()
    {
        return view('hr.report-employee.index');
    }

    public function employeeList(Request $request)
    {

        $emp_id         = $request->emp_id;
        $from_date      = $request->from_date;
        $to_date        = $request->to_date;

        $month          = $request->month;
        $y_m            = explode('-', $month);
        $y              = isset($y_m[1])?$y_m[1]:date('Y');
        $m              = isset($y_m[0])?$y_m[0]:date('m');

        $em = Employee::getEmp($request);

        return view('hr.report-employee.employee-list',[

            'from_date' => $from_date,
            'to_date'   => $to_date,
            'emp_id'    => $emp_id,
            'em'        => $em,

        ]);
    }

    public function employeeProfile(Request $request)
    {
        $emp_id         = $request->emp_id;
        $from_date      = $request->from_date;
        $to_date        = $request->to_date;

        $month          = $request->month;
        $y_m            = explode('-', $month);
        $y              = isset($y_m[1])?$y_m[1]:date('Y');
        $m              = isset($y_m[0])?$y_m[0]:date('m');

        $em = Employee::getEmp($request);

        return view('hr.report-employee.employee-profile', [

            'from_date' => $from_date,
            'to_date'   => $to_date,
            'emp_id'    => $emp_id,
            'em'        => $em,

        ]);
    }

    public function get_report_employee(Request $request)
    {

        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;

        $from_date      = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

        $count_total = User::where('status',1)
                            ->where('role','Administrator')
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('id',$emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('users.branch_id',$branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('users.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('users.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('users.user_dob', [$from_date, $to_date]);
                            })
                            ->count();
        $data       = User::where('status',1)
                            ->where('role','Administrator')
                            ->where(function($q) use($search){
                                // $q->orwhere('users.english_name','LIKE',"%$search%");
                                // $q->orwhere('users.khmer_name','LIKE',"%$search%");
                                $q->orwhere('users.email','LIKE',"%$search%");
                            })
                            ->when($emp_id, function ($q, $emp_id){
                                $q->where('id', $emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('users.branch_id', $branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('users.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('users.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('users.date_of_birth', [$from_date, $to_date]);
                            });

        $count_filter = $data->count();
        if ($request->ajax())
        {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()
                ->editColumn('branch', function ($data) {
                    return optional($data->branch)->english_name;
                })
                ->editColumn('department', function ($data) {
                    return optional($data->_department)->english_name;
                })
                ->editColumn('position', function ($data) {
                    return optional($data->position)->english_name;
                })
                ->editColumn('dob', function($data){
                    return $data->date_of_birth ? date('d-m-Y', strtotime($data->date_of_birth)) : "";
                })
                ->addColumn('khmer_name', function($data){
                    return '';
                })
                ->addColumn('english_name', function($data){
                    return $data->english_name;
                })
                ->make(true);

        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $branch     = HrBranch::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $department = HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $position   = HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');

        return view('hr.report-employee.list-employee', compact('user', 'branch', 'department', 'position'));
    }

    public function get_employee_by_branch()
    {
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $branch     = HrBranch::pluck('english_name', 'id');
        $department = HrDepartmentModel::pluck('english_name', 'id');
        $position   = HrPositionModel::pluck('english_name', 'id');

        return view('hr.report-employee.employee-by-branch', compact('user', 'branch', 'department', 'position'));
    }
    public function get_report_employee_by_branch(Request $request)
    {
        $em = Employee::getEmp($request);
        return view('hr.report-employee.employee-by-branch-show', compact('em'));
    }
}
