<?php

namespace App\Http\Controllers\HR;

use App\Helpers\IDate;
use App\Models\Hr\EmployeeLeaveTotal;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\EmpLeave;
use App\Models\Hr\Employee;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrPositionModel;
use App\Models\Hr\LeaveType;
use App\Models\Hr\TimeAttendanceGenModel;
use Yajra\DataTables\DataTables;
use App\User;
use Illuminate\Support\Facades\DB;

class ReportAttendanceController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Report Leave Summary List', ['only' => ['report_leave_summary']]);
        $this->middleware('permission:Report Attendance Fingerprint List', ['only' => ['att_from_finger_print']]);
        $this->middleware('permission:Report Daily Attendance Summary List', ['only' => ['daily_att_summary_list']]);
        $this->middleware('permission:Report Attendance List Detail', ['only' => ['list_att_details']]);
        $this->middleware('permission:Report Annual List', ['only' => ['get_annual_leave']]);
        $this->middleware('permission:Report Leave Group', ['only' => ['leave_by_group']]);
    }

    public function get_report_attendance(Request $request)
    {
        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $postion_id     = $request->postion_id;

        $from           = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to             = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

        $count_total = TimeAttendanceGenModel::where('ot_approve', 1)
                            ->when($emp_id,function($q,$emp_id){
                                $q->where('nso007_hr_time_attends_gen.emp_id',$emp_id);
                            })
                            ->groupBy('emp_id')
                            ->count();
        $data       = TimeAttendanceGenModel::where('ot_approve', 1)
                            ->when($emp_id,function($q,$emp_id){
                                $q->where('nso007_hr_time_attends_gen.emp_id',$emp_id);
                            })
                            ->groupBy('emp_id');

        $count_filter = $data->count();
        if ($request->ajax())
        {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()

                ->editColumn('employee', function ($data) {
                    return optional($data->employee)->name;
                })
                ->make(true);

        }
        return view('hr.report-attendance.list-attendance');
    }
    public function report_leave_summary(Request $request)
    {
        if($request->ajax())
        {
            $employee       = $request->employee != null ? $request->employee : [];
            $from_date      = empty($request->from_date) ? []  : date('Y-m-d',strtotime($request->from_date));
            $end_date       = empty($request->end_date) ? [] : date('Y-m-d',strtotime($request->end_date));
            $count_total    = EmployeeLeaveTotal::count();
            $data           = EmployeeLeaveTotal::when($employee,function ($q) use($employee){
                                        $q->where('emp_id',$employee);
                                    })
                                    ->when($from_date,function ($q) use($from_date,$end_date){
                                        $q->leftJoin('users','users.id','emp_leave_total.emp_id')->whereBetween('users.joined_date',[$from_date,$end_date]);
                                    });
            $count_filter   = $data->count();
            return DataTables::of($data->take(20))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter
                ])
                ->addIndexColumn()
                ->editColumn('emp_id',function ($data){
                    return optional($data->employee)->english_name;
                })
                ->editColumn('annual_leave', function($data){
                    return $data->annual_leave ? $data->annual_leave : 0;
                })
                ->editColumn('annual_leave_use', function($data){
                    return $data->annual_leave_use ? $data->annual_leave_use : 0;
                })
                ->editColumn('annual_leave_bal', function($data){
                    return $data->annual_leave_bal ? $data->annual_leave_bal : 0;
                })
                ->editColumn('sick_leave', function($data){
                    return $data->sick_leave ? $data->sick_leave : 0;
                })
                ->editColumn('sick_leave_use', function($data){
                    return $data->sick_leave_use ? $data->sick_leave_use : 0;
                })
                ->editColumn('sick_leave_bal', function($data){
                    return $data->sick_leave_bal ? $data->sick_leave_bal : 0;
                })
                ->editColumn('special_leave', function($data){
                    return $data->special_leave ? $data->special_leave : 0;
                })
                ->editColumn('special_leave_use', function($data){
                    return $data->special_leave_use ? $data->special_leave_use : 0;
                })
                ->editColumn('special_leave_bal', function($data){
                    return $data->special_leave_bal ? $data->special_leave_bal : 0;
                })
                ->editColumn('unpaid_leave', function($data){
                    return $data->unpaid_leave ? $data->unpaid_leave : 0;
                })
                ->editColumn('unpaid_leave_use', function($data){
                    return $data->unpaid_leave_use ? $data->unpaid_leave_use : 0;
                })
                ->editColumn('unpaid_leave_bal', function($data){
                    return $data->unpaid_leave_bal ? $data->unpaid_leave_bal : 0;
                })
                ->editColumn('maternity_leave', function($data){
                    return $data->maternity_leave ? $data->maternity_leave : 0;
                })
                ->editColumn('maternity_leave_use', function($data){
                    return $data->maternity_leave_use ? $data->maternity_leave_use : 0;
                })
                ->editColumn('maternity_leave_bal', function($data){
                    return $data->maternity_leave_bal ? $data->maternity_leave_bal : 0;
                })
                ->editColumn('other_leave', function($data){
                    return $data->other_leave ? $data->other_leave : 0;
                })
                ->editColumn('other_leave_use', function($data){
                    return $data->other_leave_use ? $data->other_leave_use : 0;
                })
                ->editColumn('other_leave_bal', function($data){
                    return $data->other_leave_bal ? $data->other_leave_bal : 0;
                })

                ->addColumn('emp_code',function ($data){
                    return optional($data->employee)->user_code;
                })
                ->addColumn('joined_date',function ($data){
                    return optional($data->employee)->joined_date != null ? date('d-m-Y',strtotime(optional($data->employee)->joined_date)) : '';
                })
                ->make(true);
        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');

        return view('hr.report-attendance.leave-summary', compact('user'));
    }
    public function get_annual_leave()
    {
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        return view('hr.report-attendance.annual-leave', compact('user'));
    }
    public function get_annual_leave_show(Request $request)
    {
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;
        $from_date      = $request->from_date;
        $to_date        = $request->to_date;
        $em             = Employee::getEmp($request);
        return view('hr.report-attendance.annual-leave-show', compact('em'));
    }
    public function daily_att_summary_list()
    {
        $branch     = HrBranch::pluck('english_name', 'id');
        $department = HrDepartmentModel::pluck('english_name', 'id');
        $position   = HrPositionModel::pluck('english_name', 'id');
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');

        return view('hr.report-attendance.daily-attendance-summary', compact('branch', 'department', 'position', 'user'));
    }
    public function daily_att_summary_list_show(Request $request)
    {
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;
        $from_date      = $request->from_date;
        $to_date        = $request->to_date;
        $dates          = IDate::createDateRange($from_date, $to_date);
        $em             = Employee::getEmp($request);

        return view('hr.report-attendance.show-daily-attend-summary', compact('em', 'dates'));
    }
    public function leave_by_group(Request $request)
    {
        if($request->ajax())
        {
            $employee       = $request->emp_id != null ? $request->emp_id : [];
            $from_date      = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
            $to_date        = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

            $count_total    = EmpLeave::where('review', 1)->where('approve', 1)
                                    ->when(request('from_date', ''),function ($q) use ($from_date , $to_date) {
                                        $q->whereBetween('emp_leaves.request_date', [$from_date,$to_date]);
                                    })->count();
            $data           = EmpLeave::where('review', 1)->where('approve', 1)
                                    ->when($employee,function ($q) use($employee){
                                        $q->where('emp_id', $employee);
                                    })
                                    ->when(request('from_date', ''),function ($q) use ($from_date , $to_date) {
                                        $q->whereBetween('emp_leaves.request_date', [$from_date, $to_date]);
                                    });
            $count_filter   = $data->count();

            return DataTables::of($data->take(20))
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter
                ])
                ->addColumn('code', function($data){
                    return optional($data->employee)->code;
                })
                ->addColumn('employee', function($data){
                    return optional($data->employee)->english_name;
                })
                ->editColumn('leave_type', function($value){
                    return $value->leave_type != null ? (LeaveType::findOrFail($value->leave_type)->name) : "";
                })
                ->editColumn('from_date', function($data){
                    return $data->from_date != null ? date('d-m-Y', strtotime($data->from_date)) : "";
                })
                ->editColumn('to_date', function($data){
                    return $data->to_date != null ? date('d-m-Y', strtotime($data->to_date)) : "";
                })
                ->editColumn('request_date', function($data){
                    return $data->request_date != null ? date('d-m-Y', strtotime($data->request_date)) : "";
                })
                ->rawColumns(['code'])
                ->make(true);
        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        return view('hr.report-attendance.leave-by-group', compact('user'));
    }
}
