<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrTraining;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrTrainingController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Training Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Training List', ['only' => ['index']]);
        $this->middleware('permission:Training Edit', ['only' => ['update','edit']]);
    }
    public function index(Request $request)
    {
        $training = HrTraining::get();
        if($request->ajax())
        {
            return DataTables::of($training->take(20))
            ->addIndexColumn()
            ->addColumn('action', function($row){
                $btn_edit = '';
                if(Gate::check('Training Edit')){
                    $btn_edit = '<a href="'.route('hr-training.edit',$row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';
                }
                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        return view('hr.training.index', compact('training'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.training.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $training = new HrTraining();
        $training->name = $request->name;
        $training->note = $request->note;
        $training->save();

        return redirect()->route('hr-training.index')->with('Success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrTraining  $hrTraining
     * @return \Illuminate\Http\Response
     */
    public function show(HrTraining $hrTraining)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrTraining  $hrTraining
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $training = HrTraining::find($id);
        return view('hr.training.edit', compact('training'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrTraining  $hrTraining
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $training = HrTraining::find($id);
        $training->name = $request->name;
        $training->note = $request->note;
        $training->update();

        return redirect()->route('hr-training.index')->with('Success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrTraining  $hrTraining
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrTraining $hrTraining)
    {
        //
    }
}
