<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrJobBenefitModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrJobBenefitController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Benefit Type List', ['only' => ['index','get_benefit']]);
        $this->middleware('permission:Benefit Type Create', ['only' => ['create','store']]);
        $this->middleware('permission:Benefit Type Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Benefit Type Delete', ['only' => ['delete_job_benefit']]);
    }
    public function index()
    {
        return view('hr.job-benefit.index');
    }
    public function get_benefit()
    {
        $data = HrJobBenefitModel::get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $delete = "លុបចោល";
                } else {
                    $edit = "Edit";
                    $delete = "Delete";
                }
                $btn_edit ="";
                $btn_delete="";
                if(Gate::check('Benefit Type Edit')){
                    $btn_edit .= '<a href="'.route('hr-job-benefit.edit',encrypt($data->id)).'" class="btn btn-sm btn-warning" title="'.$edit.'"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                }
                if(Gate::check('Benefit Type Delete')) {
                    $btn_delete .= '<a class="btn btn-sm btn-danger btn_job_benefit" role="button" data-id="' . $data->id . '" title="' . $delete . '"><span class="fa fa-times"></span> Delete</a>';
                }

                return $btn_edit.$btn_delete;
            })

            ->rawColumns(['action' => 'action'])
            ->make(true);
    }

    public function create()
    {
        return view('hr.job-benefit.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
        ]);

        $ben            = new HrJobBenefitModel();
        $ben->name      = $request->name;
        $ben->name_kh   = $request->kh_name;
        $ben->amount    = $request->amount;
        $ben->note      = $request->note;
        $ben->save();

        return redirect()->route('hr-job-benefit.index')->with('success','Benefit was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $ben = HrJobBenefitModel::find(decrypt($id));
        return view('hr.job-benefit.edit',compact('ben'));
    }

    public function update(Request $request, $id)
    {

        $this->validate($request,[
            'name'=>'required',
        ]);

        $ben            = HrJobBenefitModel::find($id);
        $ben->name      = $request->name;
        $ben->name_kh   = $request->name_kh;
        $ben->amount    = $request->amount;
        $ben->note      = $request->note;
        $ben->update();

        return redirect()->route('hr-job-benefit.index')->with('success','Benefit was updated successful...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //delete job benefit
    public function delete_job_benefit(Request $request)
    {
        $id = $request->delete_id;
        HrJobBenefitModel::where('id', $id)->delete();
        return redirect()->route('hr-job-benefit.index')->with('success', 'Deleted Successful!..');
    }
}
