<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\ExternalLecturerModel;
use App\Models\Hr\HrInExternalTrainingModel;
use App\Models\Hr\HrTrainingCourseModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Yajra\DataTables\DataTables;
use App\Fun\Fun;
use Illuminate\Support\Facades\Gate;

class HrInExternalTrainingController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:In-External Training Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:In-External Training List', ['only' => ['index','get_in_ex_training']]);
        $this->middleware('permission:In-External Training Edit', ['only' => ['update','edit']]);
    }
    public function index()
    {
        return view('hr.in-external-training.index');

    }

    public function get_in_ex_training()
    {

        $data = HrInExternalTrainingModel::groupby('training_course_id')->get();
        return DataTables::of($data->take(20))
            ->addIndexColumn()
            ->editColumn('emp_id', function ($data) {
                $employee = HrInExternalTrainingModel::where('training_course_id', $data->training_course_id)->get();

                $show_employee = '';
                foreach ($employee as $key => $row) {
                    $show_employee .= '<span class="right badge badge-info">' . optional($row->get_employee)->english_name . '</span>&nbsp;';
                }
                return $show_employee ;
            })

            ->editColumn('training_course_id', function($data){
                return optional($data->get_training_course)->name ? optional($data->get_training_course)->name:"";
            })

            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $btn_edit="";
                if(Gate::check('In-External Training Edit')){
                    $btn_edit.='<a href="' . route('hr-in-external-training.edit', $data->training_course_id) . '" class="btn btn-sm btn-warning"><i class="fa fa-edit"></i> ' . $edit . '</a>';
                }
                return $btn_edit;
            })
            ->rawColumns(['action' => 'action', 'emp_id' => 'emp_id'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp = User::where('status', 1)->pluck('english_name', 'id');
        $training_course = HrTrainingCourseModel::pluck('name', 'id');
        $external_lecturer = ExternalLecturerModel::pluck('full_name_en', 'id');
        return view('hr.in-external-training.create', compact('emp', 'training_course', 'external_lecturer'));
    }


    public function store(Request $request)
    {

        $this->validate($request, [
            'emp'                   => 'required',
            'training_course_id'    => 'required',
            'start_date'            => 'required',
            'end_date'              => 'required',
            'time_in'               => 'required',
            'time_out'              => 'required',
        ]);

        $trainee = $request->emp;

        if(isset($trainee))
        {
            if(is_array($trainee))
            {
                if(count($trainee))
                {
                    foreach($trainee as $key => $v)
                    {
                        $in_ex_training = new HrInExternalTrainingModel();
                        $in_ex_training->emp_id                 = $request->emp[$key];
                        $in_ex_training->training_course_id     = $request->training_course_id;
                        $in_ex_training->internal_lecturer_id   = $request->internal_lecturer_id;
                        $in_ex_training->external_lecturer_id   = $request->external_lecturer_id;
                        $in_ex_training->start_date             = date('Y-m-d', strtotime($request->start_date));
                        $in_ex_training->end_date               = date('Y-m-d', strtotime($request->end_date));
                        $in_ex_training->start_time             = $request->time_in;
                        $in_ex_training->end_time               = $request->time_out;
                        $in_ex_training->training_cost          = $request->training_cost;
                        $in_ex_training->score                  = $request->score;
                        $in_ex_training->location               = $request->location;
                        $in_ex_training->description            = $request->description;

                        $in_ex_training->save();
                    }
                }
            }
        }

        return redirect()->route('hr-in-external-training.index')->with('success', 'Added Successful!');
    }


    public function show($id)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrExternalTrainingModel  $hrExternalTrainingModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $in_ex_training = HrInExternalTrainingModel::where('training_course_id', $id)->first();
        $select_training_emp = HrInExternalTrainingModel::where('training_course_id', $id)->get();

        foreach($select_training_emp as $row)
        {
            $select[] = $row->emp_id;
        }

        $emp = User::where('status', 1)->pluck('english_name', 'id');
        $training_course = HrTrainingCourseModel::pluck('name', 'id');
        $external_lecturer = ExternalLecturerModel::pluck('full_name_en', 'id');

        return view('hr.in-external-training.edit', compact('in_ex_training','emp','training_course','external_lecturer','select'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrExternalTrainingModel  $hrExternalTrainingModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        HrInExternalTrainingModel::where('training_course_id', $id)->delete();
        $emp = $request->emp;

        if(isset($emp))
        {
            if(is_array($emp))
            {
                if(count($emp))
                {
                    foreach($emp as $k => $v)
                    {
                        $in_ex_training = new HrInExternalTrainingModel();
                        $in_ex_training->emp_id = $emp[$k];
                        $in_ex_training->training_course_id     = $request->training_course_id;
                        $in_ex_training->internal_lecturer_id   = $request->internal_lecturer_id;
                        $in_ex_training->external_lecturer_id   = $request->external_lecturer_id;
                        $in_ex_training->start_date             = date('Y-m-d',strtotime($request->start_date));
                        $in_ex_training->end_date               = date('Y-m-d',strtotime($request->end_date));
                        $in_ex_training->start_time             = $request->time_in;
                        $in_ex_training->end_time               = $request->time_out;
                        $in_ex_training->training_cost          = $request->training_cost;
                        $in_ex_training->score                  = $request->score;
                        $in_ex_training->location               = $request->location;
                        $in_ex_training->description            = $request->description;
                        $in_ex_training->save();
                    }
                }
            }
        }
        return redirect()->route('hr-in-external-training.index')->with('success', 'Updated Successful!');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrExternalTrainingModel  $hrExternalTrainingModel
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
