<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrHardSkill;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrHardSkillController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:HardSkill List', ['only' => ['index','get_holiday']]);
        $this->middleware('permission:HardSkill Create', ['only' => ['create','store']]);
        $this->middleware('permission:HardSkill Edit', ['only' => ['edit','update']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $hard_skill = HrHardSkill::get();
        if($request->ajax()){

            return DataTables::of($hard_skill->take(20))
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $hard_skill->count(),
                "recordsFiltered" => $hard_skill->count()
            ])
            ->addColumn('action', function($row){
                $btn_edit = '';
                if(Gate::check('HardSkill Edit')){
                    $btn_edit = '<a href="'.route('hr-hard-skill.edit',$row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';

                }
                return $btn_edit;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        return view('hr.hard-skill.index', compact('hard_skill'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.hard-skill.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $hard_skill = new HrHardSkill();
        $hard_skill->name = $request->name;
        $hard_skill->note = $request->note;
        $hard_skill->save();

        return redirect()->route('hr-hard-skill.index')->with('Success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrHardSkill  $hrHardSkill
     * @return \Illuminate\Http\Response
     */
    public function show(HrHardSkill $hrHardSkill)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrHardSkill  $hrHardSkill
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hard_skill = HrHardSkill::find($id);
        return view('hr.hard-skill.edit', compact('hard_skill'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrHardSkill  $hrHardSkill
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required'
        ]);

        $hard_skill = HrHardSkill::find($id);
        $hard_skill->name = $request->name;
        $hard_skill->note = $request->note;
        $hard_skill->update();

        return redirect()->route('hr-hard-skill.index')->with('Success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrHardSkill  $hrHardSkill
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrHardSkill $hrHardSkill)
    {
        //
    }
}
