<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrEmployeeRotateModel;
use App\Models\Hr\HrPositionModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class  HrEmployeeRotateController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Employee Rotate List', ['only' => ['index', 'get_rotate']]);
        $this->middleware('permission:Employee Rotate Show', ['only' => ['show_rotate']]);
        $this->middleware('permission:Employee Rotate Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Employee Rotate Delete', ['only' => ['delete_rotate']]);
    }
    public function index()
    {

        $employee_rotate = HrEmployeeRotateModel::get();
        return view('hr.employee-rotate.index', compact('employee_rotate'));
    }

    //get rotate
    public function get_rotate()
    {
        $data = HrEmployeeRotateModel::take(20);
        return DataTables::of($data)
                        ->addIndexColumn()
                        ->editColumn('rotate_date', function($data){
                            return $data->rotate_date ? date('d-m-Y', strtotime($data->rotate_date)) : "";
                        })
                        ->editColumn('current_branch', function($data){
                            return optional($data->from_branch)->english_name;
                        })
                        ->editColumn('current_department', function($data){
                            return optional($data->from_department)->english_name;
                        })
                        ->editColumn('current_position', function($data){
                            return optional($data->from_position)->english_name;
                        })
                        ->editColumn('transfer_branch', function($data){
                            return optional($data->to_branch)->english_name;
                        })
                        ->editColumn('transfer_department', function($data){
                            return optional($data->to_department)->english_name;
                        })
                        ->editColumn('transfer_position', function($data){
                            return optional($data->to_position)->english_name;
                        })
                        ->editColumn('action', function($data){
                            $btn_view   = "";
                            $btn_delete = "";
                            if(Gate::check('Employee Rotate Show')){
                                $btn_view .= '<a class="btn btn-sm btn-info btn-show" data-id="'.$data->id.'"><span class="fa fa-eye"></span> Show</a>&nbsp;';
                            }
                            if(Gate::check('Employee Rotate Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn-delete" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_view.$btn_delete;
                        })
                        ->rawColumns(['action' => 'Action'])
                        ->make(true);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrEmployeeRotateModel  $hrEmployeeRotateModel
     * @return \Illuminate\Http\Response
     */
    public function show(HrEmployeeRotateModel $hrEmployeeRotateModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrEmployeeRotateModel  $hrEmployeeRotateModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $emp_rotate     = User::find($id);
        $position       = HrPositionModel::pluck('english_name', 'id');
        $department     = HrDepartmentModel::pluck('english_name','id');
        $branch         = HrBranch::pluck('english_name', 'id');
        return view('hr.employee-rotate.edit', compact('id', 'emp_rotate','position','department','branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrEmployeeRotateModel  $hrEmployeeRotateModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'rotate_date'   => 'required',
            'reason'        => 'required'
        ]);

        if($request->type == '1')
        {
            $emp = User::where('id', $id)->first();

            $employee_rotate = new HrEmployeeRotateModel();

            $employee_rotate->parent_id                 = $emp->parent_id;
            $employee_rotate->leader_id                 = $emp->leader_id;
            $employee_rotate->group_id                  = $emp->group_id;

            $employee_rotate->current_branch_id         = $emp->branch_id;
            $employee_rotate->current_department_id     = $emp->department_id;
            $employee_rotate->current_position_id       = $emp->position_id;

            $employee_rotate->employment_id             = $emp->employment_id;
            $employee_rotate->user_year                 = $emp->user_year;
            $employee_rotate->code                      = $emp->user_code;
            $employee_rotate->name                      = $emp->english_name;
            $employee_rotate->name_kh                   = $emp->khmer_name;
            $employee_rotate->phone                     = $emp->user_phone;
            $employee_rotate->email                     = $emp->email;
            $employee_rotate->nationality               = $emp->nationality;
            $employee_rotate->date_of_birth             = $emp->user_dob;
            $employee_rotate->address                   = $emp->address;
            $employee_rotate->place_of_birth            = $emp->place_of_birth;
            $employee_rotate->gender                    = $emp->user_gender;
            $employee_rotate->marital_status            = $emp->marital_status;
            $employee_rotate->id_card                   = $emp->user_cardid;
            $employee_rotate->avartar                   = $emp->avatar;
            $employee_rotate->joined_date               = $emp->joined_date;
            $employee_rotate->department                = $emp->department;
            $employee_rotate->is_role                   = $emp->is_role;
            $employee_rotate->role                      = $emp->role;
            $employee_rotate->supervisor                = $emp->supervisor;
            $employee_rotate->certificate               = $emp->certificate;
            $employee_rotate->skill                     = $emp->skill;
            $employee_rotate->dependent                 = $emp->dependent;
            $employee_rotate->note                      = $emp->note;
            $employee_rotate->status                    = $emp->status;
            $employee_rotate->user_type                 = $emp->user_type;
            $employee_rotate->basic_salary              = $emp->basic_salary;
            $employee_rotate->language                  = $emp->language;
            $employee_rotate->educate                   = $emp->educate;
            $employee_rotate->emergency_contact         = $emp->emergency_contact;
            $employee_rotate->family                    = $emp->family;
            $employee_rotate->family_full               = $emp->family_full;
            $employee_rotate->work_experience           = $emp->work_experience;
            $employee_rotate->spouse                    = $emp->spouse;
            $employee_rotate->child                     = $emp->child;
            $employee_rotate->increment                 = $emp->increment;
            $employee_rotate->meal_transport_allowance  = $emp->meal_transport_allowance;
            $employee_rotate->position_allowance        = $emp->position_allowance;
            $employee_rotate->other_allowance           = $emp->other_allowance;
            $employee_rotate->status                    = $emp->status;

            $employee_rotate->transfer_branch_id        = $request->branch_id;
            $employee_rotate->transfer_department_id    = $request->department_id;
            $employee_rotate->transfer_position_id      = $request->position_id;
            $employee_rotate->rotate_date               = date('Y-m-d',strtotime($request->rotate_date));
            $employee_rotate->reason                    = $request->reason;
            $employee_rotate->type                      = $request->type;
            $employee_rotate->save();
        }

        if($request->type == '1')
        {
            $employee = User::where('id', $id)->first();

            $employee->branch_id        = $request->branch_id;
            $employee->department_id    = $request->department_id;
            $employee->position_id      = $request->position_id;
            $employee->update();
        }

        return redirect()->route('hr-emp-rotate.index')->with('success', 'Rotation Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrEmployeeRotateModel  $hrEmployeeRotateModel
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //show rotate
    public function show_rotate(Request $request)
    {
        $data = HrEmployeeRotateModel::find($request->id);
        $data->load(['from_branch', 'from_department','from_position','to_branch', 'to_department', 'to_position']);
        return response()->json($data);
    }

    //delete rotate
    public function delete_rotate(Request $request)
    {
        $id = $request->delete_id;
        HrEmployeeRotateModel::where('id', $id)->delete();
        return redirect()->route('hr-emp-rotate.index')->with('succss', 'Deleted Successful!..');
    }
}
