<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\JournalModel;
use App\AccountChartModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use Gate;
use Illuminate\Database\Eloquent\Collection;

class ExpenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct(){
        $this->middleware('permission:Add-Expense', ['only' => ['create','store']]);
        $this->middleware('permission:List-Expense', ['only' => ['index']]);
        $this->middleware('permission:Edit-Expense', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete-Expense', ['only' => ['delete']]);
    }
    public function index(Request $request)
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $last_months = $request->last_months;
                $voucher_ref = $request->voucher_ref;
                $journal_acccode = $request->journal_acccode;
                $journal_des = $request->journal_des;
                $pay_to = $request->pay_to;
                $count_total = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id',
                                    'jn.person_name'
                                )
                                ->where("journal_status",0)
                                ->where("journal_acccode","LIKE","5%")
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();
                $count_filter = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id',
                                    'jn.person_name'
                                )
                                ->where("journal_status",0)
                                ->where("journal_acccode","LIKE","5%")
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id)){
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                    }
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($journal_des){
                                    if(!empty($journal_des)){
                                        $query->where("jn.journal_des","LIKE","%".$journal_des."%");
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->where(function($query) use ($pay_to){
                                    if(!empty($pay_to)){
                                        $query->where("jn.person_name","LIKE","%".$pay_to."%");
                                    }
                                })
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();
                $data = DB::table('nso007_journal as jn')
                            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                            ->select(
                                'chart.acc_name',
                                'chart.code as account_code',
                                'jn.id',
                                'jn.journal_des',
                                'jn.journal_debit',
                                'jn.journal_credit',
                                'jn.journal_invoice',
                                'jn.journal_paydate',
                                'jn.voucher_type',
                                'jn.voucher_ref',
                                'jn.journal_status',
                                'project.name as project_name',
                                'jn.journal_tran_id as tran_id',
                                'jn.delete_status',
                                'jn.person_name'
                            )
                            ->where("journal_status",0)
                            ->where("journal_acccode","LIKE","5%")
                            ->where(function($query) use ($project_id){
                                if(!empty($project_id))
                                    $query->whereIn("jn.journal_by_project",$project_id);
                            })
                            ->where(function($query) use ($start_date,$end_date){
                                if(!empty($start_date)&&!empty($end_date)){
                                    $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                }
                            })
                            ->where(function($query) use ($last_months){
                                if(!empty($last_months)){
                                    $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                }
                            })
                            ->where(function($query) use ($voucher_ref){
                                if(!empty($voucher_ref)){
                                    $query->where("jn.voucher_ref",$voucher_ref);
                                }
                            })
                            ->where(function($query) use ($journal_des){
                                if(!empty($journal_des)){
                                    $query->where("jn.journal_des","LIKE","%".$journal_des."%");
                                }
                            })
                            ->where(function($query) use ($journal_acccode){
                                if(!empty($journal_acccode)){
                                    $query->whereIn("jn.journal_acccode",$journal_acccode);
                                }
                            })
                            ->where(function($query) use ($pay_to){
                                if(!empty($pay_to)){
                                    $query->where("jn.person_name","LIKE","%".$pay_to."%");
                                }
                            })
                            ->orderBy("jn.journal_paydate","DESC")
                            ->take(20);
            return DataTables::of($data)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('voucher', function ($data) {
                    $voucher = "";
                    if ($data->voucher_type == 1) {
                        $voucher = "Cash Receipt";
                    } else if ($data->voucher_type == 2) {
                        $voucher = "Cash Disbursement";
                    } else if ($data->voucher_type == 3) {
                        $voucher = "Cash Reimbursement";
                    } else if ($data->voucher_type == 4) {
                        $voucher = "Cash Advance";
                    } else if ($data->voucher_type == 5) {
                        $voucher = "Advance Settlement";
                    } else if ($data->voucher_type == 6) {
                        $voucher = "Journal Entry/Adjustment";
                    }
                    return $voucher;
                })
                ->editColumn('journal_paydate',function($data){
                    return date("d-m-Y",strtotime($data->journal_paydate));
                })
                ->editColumn('journal_debit',function($data){
                    return "$".number_format($data->journal_debit,2);
                })
                ->editColumn('account_code', function ($data) {
                    return $data->account_code . " " . $data->acc_name;
                })
                ->addColumn('action',function($data){
                    $btn_edit = '';
                    $btn_delete = '';
                    if($data->journal_status==0 && $data->delete_status != 0){
                        if(Gate::check('Edit-Expense'))
                            $btn_edit.= '<a href="'.route('expense.edit',$data->id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                        if(Gate::check('Delete-Expense'))
                            $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->id.'" onclick="delete_expense('.$data->id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                    }
                    return $btn_edit.$btn_delete;
                })
                ->rawColumns(['action' => 'action'])
                ->make(true);
            }
        }
        return view('accounting.expense.index', ['acc_code' => $acc_code,'projects' => $projects]);
    }

    public function search_sub_chart($main_chart,$total=0,$request){
        #Find child & sum child value
        $childs = AccountChartModel::join("nso007_journal","nso007_journal.journal_acccode","nso007_account_chart.code")
        ->select("nso007_journal.*","nso007_account_chart.id as chart_id")
        ->where("acctype",$main_chart)
        ->where("journal_status",0)
        // ->where(function($query) use($request){
        //     if(!empty($request->journal_acccode)){
        //         $query->whereIn("nso007_journal.journal_acccode",$request->journal_acccode);
        //     }
        // })
        ->where(function($query) use($request){
            if(!empty($request->project_id)){
                $query->whereIn("journal_by_project",$request->project_id);
            }
        })
        ->where(function($query) use ($request){
            if(!empty($request->start_date)&&!empty($request->end_date)){
                $query->whereBetween("journal_paydate",[date("Y-m-d",strtotime($request->start_date)),date("Y-m-d",strtotime($request->end_date))]);
            }
        })
        ->where(function($query) use ($request){
            if(!empty($request->filter_date)){
                if($request->filter_date=="1"){//Today
                    $query->where("journal_paydate",date("Y-m-d"));
                }
                if($request->filter_date=="2"){
                    $query->whereBetween("journal_paydate",\Globals::this_week());
                }
            }
        })
        ->where("nso007_account_chart.code","LIKE","5%")
        ->get();
        if(!empty($childs)&&count($childs)>0){
            foreach($childs as $value){
                $total += (!empty(@$value->journal_debit&&$value->journal_debit>0)?$value->journal_debit:0);
                $this->search_sub_chart($value->chart_id,$total,$request);
            }
        }
        return $total;
    }

    public function list(Request $request){
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        $main_charts_search =  DB::table('nso007_account_chart')
            ->where(function($query){
                $query->where("acctype",60);
                $query->where("code","LIKE","5%");
            })
            ->orWhere(function($query){
                $query->whereNull("acctype");
                $query->where("code","LIKE","5%");
            })
            ->pluck("acc_name",'code');

        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $with_sub_account = $request->with_sub_account;
                $journal_acccode = $request->journal_acccode;
                $filter_date = $request->filter_date;

                if(!empty($journal_acccode)&&$with_sub_account==2){
                    $data_value = DB::table('nso007_journal as jn')
                        ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                        ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                        ->select(
                            'chart.acc_name',
                            'chart.code as account_code',
                            'jn.id',
                            'jn.journal_des',
                            'jn.journal_debit',
                            'jn.journal_credit',
                            'jn.journal_invoice',
                            'jn.journal_paydate',
                            'jn.voucher_type',
                            'jn.voucher_ref',
                            'jn.journal_status',
                            'project.name as project_name',
                            'jn.journal_tran_id as tran_id',
                            'jn.delete_status'
                        )
                        ->where("journal_status",0)
                        ->where("journal_acccode","LIKE","5%")
                        ->where(function($query) use ($project_id){
                            if(!empty($project_id))
                                $query->whereIn("jn.journal_by_project",$project_id);
                        })
                        ->where(function($query) use ($start_date,$end_date){
                            if(!empty($start_date)&&!empty($end_date)){
                                $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                            }
                        })
                        ->where(function($query) use ($filter_date){
                            if(!empty($filter_date)){
                                if($filter_date=="1"){//Today
                                    $query->where("jn.journal_paydate",date("Y-m-d"));
                                }
                                if($filter_date=="2"){
                                    $query->whereBetween("jn.journal_paydate",\Globals::this_week());
                                }
                            }
                        })
                        ->where(function($query) use ($journal_acccode){
                            if(!empty($journal_acccode)){
                                $query->whereIn("jn.journal_acccode",$journal_acccode);
                            }
                        })
                        ->orderBy("jn.journal_paydate","DESC");
                    $count_filter = $data_value->count();
                    $data_value->take(20);
                    return DataTables::of($data_value)
                        ->addIndexColumn()
                        ->with([
                            "recordsTotal" => $count_filter,
                            "recordsFiltered" => $count_filter,
                        ])
                        ->editColumn('date',function($data){
                            return date("d-m-Y",strtotime($data->journal_paydate));
                        })
                        ->editColumn('name',function($data){
                            return $data->account_code;
                        })
                        ->editColumn('sub_account',function($data){
                            return $data->account_code . " " . $data->acc_name;
                        })
                        ->editColumn('amount',function($data){
                            return "$".number_format($data->journal_debit,2);
                        })
                        ->make(true);
                } else {
                    #Get Main Account Chart
                    $main_charts =  DB::table('nso007_account_chart')
                    ->where(function($query) use($journal_acccode){
                        if(!empty($journal_acccode)){
                            $query->whereIn("code",$journal_acccode);
                        }
                    })
                    ->where(function($query){
                        $query->where("acctype",60);
                        $query->where("code","LIKE","5%");
                    })
                    ->orWhere(function($query){
                        $query->whereNull("acctype");
                        $query->where("code","LIKE","5%");
                    })
                    ->get();
                    $data = array();
                    $data_value = new Collection();
                    foreach($main_charts as $key=>$value){

                        $journals = DB::table('nso007_journal')
                                        ->where("journal_status",0)
                                        ->where("journal_acccode",$value->code)
                                        ->where(function($query) use($project_id){
                                            if(!empty($project_id)){
                                                $query->whereIn("journal_by_project",$project_id);
                                            }
                                        })
                                        ->where(function($query) use ($start_date,$end_date){
                                            if(!empty($start_date)&&!empty($end_date)){
                                                $query->whereBetween("journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                            }
                                        })
                                        ->where(function($query) use ($filter_date){
                                            if(!empty($filter_date)){
                                                if($filter_date=="1"){//Today
                                                    $query->where("journal_paydate",date("Y-m-d"));
                                                }
                                                if($filter_date=="2"){
                                                    $query->whereBetween("journal_paydate",\Globals::this_week());
                                                }
                                            }
                                        })
                                        ->get();
                        $total_amount = 0;
                        foreach($journals as $jn){
                            $total_amount += (!empty($jn->journal_debit)&&$jn->journal_debit>0?$jn->journal_debit:0);
                        }
                        if(empty($value->acctype)){
                            $data[$key] = array(
                                'date'=>@$value->date,
                                "name"=>$value->acc_name,
                                "sub_account"=>@$value->sub_account,
                                'amount'=>$total_amount,
                                'description'=>@$value->description,
                                'id'=>$value->id,
                                'acctype'=>$value->acctype,
                                'code'=>$value->code
                            );
                        }
                        else{
                            $data[$key] = array(
                                'date'=>@$value->date,
                                "name"=>$value->acc_name,
                                "sub_account"=>@$value->sub_account,
                                'amount'=>$this->search_sub_chart($value->id,$total_amount,$request),
                                'description'=>@$value->description,
                                'id'=>$value->id,
                                'acctype'=>$value->acctype,
                                'code'=>$value->code
                            );
                        }
                        if($data[$key]['amount']>0) $data_value->push($data[$key]);
                    }
                    $count_filter = count($data_value);
                    return DataTables::of($data_value)
                        ->addIndexColumn()
                        ->with([
                            "recordsTotal" => $count_filter,
                            "recordsFiltered" => $count_filter,
                        ])
                        ->addColumn('date',function($row){
                            if(empty($row['date'])) return "";
                            return date("d-m-Y",strtotime($row['date']));
                        })
                        ->addColumn('amount',function($row){
                            return "$".number_format($row['amount'],2);
                        })
                        ->make(true);
                }
            }
        }
        //Expense get by main account (New)
        return view('accounting.expense.list', ['acc_code' => $acc_code,'projects' => $projects,'main_charts_search'=>$main_charts_search]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('accounting.expense.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required',
            'cash_type'=>'required'
        ]);

        $max            = JournalModel::max('journal_tran_id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        $expense = new JournalModel;
        $expense->journal_parentid = 0;
        $expense->journal_type = 50000;
        $expense->journal_acccode = $request->journal_acccode;
        $expense->voucher_type = 2;
        $expense->voucher_ref = $voucher_ref;
        $expense->journal_des = $request->description;
        $expense->journal_debit = $request->amount;
        $expense->journal_credit = 0;
        $expense->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $expense->journal_by = Auth::user()->id;
        $expense->journal_transactiondate = date('Y-m-d H:i:s');
        $expense->journal_tran_id = $journal_tran_id;
        $expense->journal_by_project = $request->journal_by_project;
        $expense->journal_status= 0;
        $expense->person_name = $request->person_name;
        $expense->transaction_type = "Acc-Expense";
        $expense->ref_account_chart = $request->journal_acccode;
        $expense->save();

        $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();
        $cash = new JournalModel;
        $cash->journal_parentid = $jj->last_id;
        $cash->journal_type = 10000;
        $cash->journal_acccode = $request->cash_type;
        $cash->voucher_type = 2;
        $cash->voucher_ref = $voucher_ref;
        $cash->journal_des = $request->description;
        $cash->journal_debit = 0;
        $cash->journal_credit = $request->amount;
        $cash->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $cash->journal_by = Auth::user()->id;
        $cash->journal_transactiondate = date('Y-m-d H:i:s');
        $cash->journal_tran_id = $journal_tran_id;
        $cash->journal_by_project = $request->journal_by_project;
        $cash->journal_status= 0;
        $cash->person_name = $request->person_name;
        $cash->transaction_type = "Acc-Expense";
        $cash->ref_account_chart = $request->journal_acccode;
        $cash->save();

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('expense.index')->with("success","Create Successfully!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = JournalModel::find($id);
        $cash_type = JournalModel::where("journal_type",10000)->where("journal_tran_id",$data->journal_tran_id)->first();
        return view('accounting.expense.edit',compact('data','cash_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'journal_debit'=>'required',
            "cash_type"=>'required',
            "cash_id"=>'required'
        ]);

        JournalModel::where("id",$id)->update([
            'journal_acccode'           => $request->journal_acccode,
            'journal_des'               => $request->description,
            'journal_debit'            => $request->journal_debit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'person_name'              =>$request->person_name,
            'transaction_type'         =>"Acc-Expense",
            'ref_account_chart'        =>$request->journal_acccode
        ]);

        JournalModel::where("id",$request->cash_id)->update([
            'journal_acccode'           => $request->cash_type,
            'journal_des'               => $request->description,
            'journal_credit'            => $request->journal_debit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'person_name'              =>$request->person_name,
            'transaction_type'         =>"Acc-Expense",
            'ref_account_chart'        =>$request->journal_acccode
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('expense.index')->with("success","Update Successfully!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete()
    {
        $journal_id = $_GET['id'];
        $journal = JournalModel::find($journal_id);
        JournalModel::where("journal_tran_id",$journal->journal_tran_id)->delete();
        return redirect()->route('expense.index')->with("success","Delete Successfully!");
    }
    public function destroy($id)
    {
        //
    }
}
