<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\SaleModel;
use Auth;
use DB;
use DataTables;

class DepositCancellationController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Cancel-Deposit-List', ['only' => ['index','get_index']]);
    }
    public function index()
    {
    	return view("deposit-cancellation.index");
    }
    public function get_index(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                    ->leftjoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                    ->where("nso007_sale_stock.status",0)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    // ->groupBy("nso007_sale_stock.id")
                    ->count();
        $count_filter =SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                    ->leftjoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_sale_stock.updated_at' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_sale_stock.date' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_sale_stock.date_on_contract' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where("nso007_sale_stock.status",0)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    // ->groupBy("nso007_sale_stock.id")
                    ->count();

        $sale_data = SaleModel::join("nso007_sale_detail_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_sale_detail_stock.item_id","nso007_item_stock.id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_client","nso007_sale_stock.client_id","nso007_client.id")
                    ->leftjoin("nso007_agency","nso007_sale_stock.agency_id","nso007_agency.id")
                    ->select(DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),"nso007_project_stock.name as project_name","nso007_category_stock.name as category_name","nso007_client.name as client_name","nso007_client.phone as client_phone","nso007_agency.name as agency_name","nso007_sale_stock.*")
                    ->where("nso007_sale_stock.status",0)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->groupBy("nso007_sale_stock.id")
                    ->take(20);
        return Datatables::of($sale_data)
            ->addIndexColumn()
            ->setRowId("id")
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->editColumn('updated_at',function($sale_data){
                return date('d-m-Y',strtotime($sale_data->updated_at));
            })
            ->editColumn("date",function($sale_data){
                if(empty($sale_data->date)) return "";
                return date("d-m-Y",strtotime($sale_data->date));
            })
            ->editColumn("date_on_contract",function($sale_data){
                return "<span id='contract-date".$sale_data->id."'>".date("d-m-Y",strtotime($sale_data->date_on_contract))."</span>";
            })
            ->editColumn("sale_amount",function($sale_data){
                return number_format($sale_data->sale_amount,2)."$";
            })
            ->editColumn("sale_receive_amount",function($sale_data){
                return "<span id='receive-amount".$sale_data->id."'>".number_format($sale_data->sale_receive_amount,2)."$</span>";
            })
            ->editColumn('item_name',function($sale_data)
            {
                $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$sale_data->id)->select("item_id")->get();
                $item_names="";
                foreach ($sale_item as $key => $value) {
                    $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                    if(isset($sale_item[$key+1])) $item_names.=",";
                }
                return $item_names;
            })
             ->rawColumns([
                'date_on_contract'=>'date_on_contract',
                'sale_receive_amount'=>'sale_receive_amount'
            ])
            ->make(true);
    }
}
