<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProvinceModel;
use DB;
use App\ClientModel;
use Auth;
use DataTables;
use Illuminate\Support\Facades\Crypt;
use App\CustomerFeedbackModel;
use App\User;
use Gate;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Prospect-List', ['only' => ['index','datatable_get_customer']]);
         $this->middleware('permission:Prospect-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Prospect-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Prospect-Delete', ['only' => ['destroy']]);
         $this->middleware('permission:Prospect-Feed-Back', ['only' => ['add_feedback','get_feedback']]);
    }

    public function index()
    {
      $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
      return view("customer.index",compact('provinces'));
    }

    public function datatable_get_customer(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =ClientModel::join("users","users.id","nso007_client.user_id")
                        ->where("nso007_client.status",1)
                        ->where("nso007_client.user_id",Auth::user()->id)
                        ->count();
        $count_filter =ClientModel::join("users","users.id","nso007_client.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.nick_name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_client.status",1)
                        ->where("nso007_client.user_id",Auth::user()->id)
                        ->count();

        $customers = ClientModel::with(['get_province','get_district','get_commune','get_village'])->join("users","users.id","nso007_client.user_id")
                            ->select("nso007_client.*")
                            ->where("nso007_client.status",1)
                            ->where("nso007_client.user_id",Auth::user()->id)
                            ->orderBy('nso007_client.id','asc')
                            ->take(20);
        return Datatables::of($customers)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->addColumn('action',function($customers){
                $button="";
                if(Gate::check('Prospect-Feed-Back'))
                  $button.= ' <a href="'.Route("customer.feedback", Crypt::encrypt($customers->id)).'"  class="btn btn-primary btn-sm" data-toggle="tooltip" data-placement="top" title="view & add feedback"><i class="fas fa-eye"></i></a> ';
                if($customers->type==0)
                  $button.= ' <a type="button" title="Change to client." class="btn btn-sm btn-info" href="'.route('client.edit', Crypt::encrypt($customers->id)).'"><i class="fas fa-user-edit"></i></a>';
                if(Gate::check('Prospect-Edit'))
                  $button.= ' <a href="'.Route("customer.edit", Crypt::encrypt($customers->id)).'"  class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';
                // $button.= ' <a type="button" title="Change to another agent." class="btn btn-sm btn-success" href="'.route('client.edit', Crypt::encrypt($customers->id)).'"><i class="fas fa-user-edit"></i></a> ';
                if(Gate::check('Prospect-Delete')){
                  if($customers->delete_status==0){
                    $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                  }elseif($customers->delete_status==1){
                      $button .= ' <button type="button" data-toggle="modal" data-target="#modal-danger'.$customers->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                      <div class="modal fade" id="modal-danger'.$customers->id.'">
                            <form action="'.route("customer.delete",$customers->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                      ';
                  }else{

                  }
                }
                
                return $button;
            })
            ->editColumn("type",function($customers){
                if($customers->type==0){
                    return "<span class='text-success'>Customer</span>";
                }else{
                    return "<span class='text-success'>Client</span>";
                }
            })
            ->editColumn("address",function($customers){
                $location="";
                if(!empty($customers->house_number)) $location.=$customers->house_number;
                if(!empty($customers->street_number)) $location.=" ,".$customers->street_number;
                if(!empty($customers->get_village['village_km'])) $location.="  ភូមិ ".$customers->get_village['village_km'];
                if(!empty($customers->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$customers->get_commune['commune_km'];
                if(!empty($customers->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$customers->get_district['district_km'];
                if(!empty($customers->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$customers->get_province['province_km'];
                return $location;
            })
             ->rawColumns([
                'action' => 'action',
                "type"=>"type"
            ])
            ->make(true); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        return view("customer.create",compact("provinces"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            "name"=>'required',
            "phone"=>'required',
            "gender"=>'required'
        ]);

        $Customer = new ClientModel;
        $Customer->name = $request->name;
        $Customer->phone = $request->phone;
        $Customer->nationality = $request->nationality;
        $Customer->house_number = $request->house_number;
        $Customer->province = $request->province;
        $Customer->commune = $request->commune;
        $Customer->village = $request->village;
        $Customer->nick_name = $request->nick_name;
        $Customer->gender = $request->gender;
        if(!empty($request->date_of_birth))
            $Customer->date_of_birth = date("Y-m-d",strtotime($request->date_of_birth));
        $Customer->street_number = $request->street_number;
        $Customer->district = $request->district;
        $Customer->description = $request->description;
        $Customer->user_id = Auth::user()->id;
        $Customer->type = 0;
        $Customer->date = date("Y-m-d");
        $Customer->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("customer.index")->with("success","Customer create successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $customer=ClientModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return json_encode($customer);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $customer=ClientModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return view("customer.edit",compact('provinces','customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            "name"=>'required',
            "phone"=>'required',
            "gender"=>'required'
        ]);

        $Customer = ClientModel::find($id);
        $Customer->name = $request->name;
        $Customer->phone = $request->phone;
        $Customer->nationality = $request->nationality;
        $Customer->house_number = $request->house_number;
        $Customer->province = $request->province;
        $Customer->commune = $request->commune;
        $Customer->village = $request->village;
        $Customer->nick_name = $request->nick_name;
        $Customer->gender = $request->gender;
        if(!empty($request->date_of_birth))
            $Customer->date_of_birth = date("Y-m-d",strtotime($request->date_of_birth));
        $Customer->street_number = $request->street_number;
        $Customer->district = $request->district;
        $Customer->description = $request->description;
        $Customer->save();

        return redirect()->route("customer.index")->with("success","Customer update successfully !");
    }

    public function change_to_client(Request $request)
    {
      $this->validate($request,[
        'id'=>'required'
      ]);
      ClientModel::where("id",$request->id)->update(["type"=>1]);
      return \back()->with("success","Change successfully !");
      
    }

    public function feedback($id=null){
      $id=Crypt::decrypt($id);
      $customer_name=ClientModel::find($id)->name;
      return view("customer.feedback",['customer_id'=>$id],compact('customer_name'));
    }
    public function add_feedback(Request $request){

      $this->validate($request,[
          'customer'=>'required',
          'date'=>'required',
          'description'=>'required',
          'customer_id'=>'required'
        ]);
        $feedback= new CustomerFeedbackModel;
        $feedback->customer_id=$request->customer_id;
        $feedback->date=date("Y-m-d",strtotime($request->date));
        $feedback->description=$request->description;
        $feedback->save();
        $id=$request->customer_id;

        return redirect()->route("customer.feedback",Crypt::encrypt($id));
    }
    public function get_feedback($id,Request $request){
      $search = $request->input('search.value');
        $count_total =CustomerFeedbackModel::where("customer_id",$id)
                        ->count();
        $count_filter =CustomerFeedbackModel::
                        where(function($query) use ($search){
                            $query->orWhere('nso007_customer_feedback.date' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_customer_feedback.description' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("customer_id",$id)
                        ->count();

        $customer_feedback = CustomerFeedbackModel::where("customer_id",$id)
                            ->take(20);
        return Datatables::of($customer_feedback)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->addColumn('action',function($customer_feedback){
                $customer_name=ClientModel::find($customer_feedback->customer_id)->name;
                $status= '<a href="#customer-add-feedback-edit" class="btn btn-success btn-sm" data-customer-name="'.$customer_name.'" data-date="'.date("d-m-Y",strtotime($customer_feedback->date)).'" data-description="'.$customer_feedback->description.'" data-id="'.$customer_feedback->id.'" data-customer-id="'.$customer_feedback->customer_id.'" data-toggle="modal" onclick="edit(this)"> <i class="fa fa-edit"></i></a> 
                <a href="#confirm-delete-customer-feedback" onclick="delete_customer('.$customer_feedback->id.')" data-toggle="modal" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>';
                return $status;
            })
            ->addColumn("customer_name",function($customer_feedback){
               return ClientModel::find($customer_feedback->customer_id)->name;
            })
            ->addColumn("customer_phone",function($customer_feedback){
              return ClientModel::find($customer_feedback->customer_id)->phone;
            })
            ->editColumn('date',function($customer_feedback){
              return date("d-m-Y",strtotime($customer_feedback->date));
            })
             ->rawColumns([
                'action' => 'action'
            ])
            ->make(true); 
    }

    public function update_feedback(Request $request){
      $this->validate($request,[
          'customer'=>'required',
          'date'=>'required',
          'description'=>'required',
          'customer_id'=>'required'
        ]);
      $feedback= CustomerFeedbackModel::find($request->id);
      $feedback->customer_id=$request->customer_id;
      $feedback->date=date("Y-m-d",strtotime($request->date));
      $feedback->description=$request->description;
      $feedback->save();
      $customer_id=$request->customer_id;

      return redirect()->route("customer.feedback",Crypt::encrypt($customer_id))->with("success","Update successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy_customer_feedback(Request $request)
    {
        $id=$request->id;
        CustomerFeedbackModel::where("id",$id)->delete();
        return back()->with("success","Delete successfully !");
    }
    public function delete($id)
    {
      ClientModel::where('id',$id)->delete();
      return \back()->with('success','Delete successfully');
    }
}
