<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\CategoryConStockModel;
use DB;

class CategoryConStock extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Category-Construction-List', ['only' => ['index']]);
         $this->middleware('permission:Category-Construction-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Category-Construction-Edit', ['only' => ['con_update']]);
    }
    public function index()
    {
        $data=CategoryConStockModel::all();
        return view('construction-stock.categories.index',['data'=>$data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('construction-stock.categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=array(
            'pcat_name'=>$request->input("category_name"),
            'pcat_des'=>$request->input("category_des")
        );
        CategoryConStockModel::insert($data);
        return redirect(route('category-construction.index'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function con_update(Request $request){
        $id=$request->input('pcat_id');
        $data=array(
            'pcat_name'=>$request->input('pcat_name'),
            'pcat_des'=>$request->input('pcat_des')
        );
        $cat=DB::table('nso007_category_construction')->where('pcat_id',$id)->update(['pcat_name'=>$data['pcat_name'],'pcat_des'=>$data['pcat_des']]);
        return redirect(route('category-construction.index'))->with('success','Category updated successfully');
    }
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
