<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProjectModel;
use App\BlockModel;
use DataTables;
use Auth;
use Crypt;
use App\User;
use App\ItemModel;
use Gate;

class BlockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Zone-List', ['only' => ['index','get_block']]);
         $this->middleware('permission:Zone-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Zone-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Zone-Delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $project=ProjectModel::where("status",1)->pluck('name','id')->prepend("Please Select"," ");
        return view("block.index",compact('project'));
    }

    public function get_block(Request $request)
    {
        if($request->isMethod("POST")){
            $block=BlockModel::where("nso007_block.id",$request->id)->join("nso007_project_stock","nso007_project_stock.id",'nso007_block.project_id')->select("nso007_block.*","nso007_project_stock.id as project_id","nso007_project_stock.name as project_name")->first();
            $project=ProjectModel::where("status",1)->get();
            $data = array('block' =>$block ,"project"=>$project );
            return json_encode($data);
        }
        else{
            $search = $request->input('search.value');
            $count_total =BlockModel::join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                            ->where("nso007_block.status",1)
                            ->count();
            $count_filter =BlockModel::join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_block.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where("nso007_block.status",1)
                            ->count();

            $blocks = BlockModel::join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                                ->select("nso007_block.*","nso007_project_stock.name as project_name")
                                ->orderBy('nso007_block.id','asc')
                                ->where("nso007_block.status",1)
                                ->take(20);
            return Datatables::of($blocks)
                ->addIndexColumn()
                ->setRowId('id')
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->addColumn('action',function($blocks){
                    if($blocks->delete_status==0){
                        if(Gate::check('Zone-Edit'))
                            $button= ' <button href="#" disabled class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Edit" onclick="edit_block(this)"><i class="fas fa-edit"></i></button> ';
                        if(Gate::check('Zone-Delete'))
                            $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($blocks->delete_status==1){
                        if(Gate::check('Zone-Edit'))
                            $button= ' <a href="#"  class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Edit" onclick="edit_block(this)"><i class="fas fa-edit"></i></a> ';
                        if(Gate::check('Zone-Delete'))
                            $button .= ' <button type="button" data-toggle="modal" data-target="#modal-danger'.$blocks->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                                <div class="modal fade" id="modal-danger'.$blocks->id.'">
                                    <form action="'.route("block.delete",$blocks->id).'" method="GET" style="display:inline">
                                      <div class="modal-dialog">
                                        <div class="modal-content bg-danger">
                                          <div class="modal-header">
                                            <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>
                                          <div class="modal-body">
                                            <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                          </div>
                                          <div class="modal-footer justify-content-between">
                                            <a>&nbsp;</a>
                                            <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                          </div>
                                        </div>
                                        <!-- /.modal-content -->
                                      </div>
                                      <!-- /.modal-dialog -->
                                    </form>
                                </div>
                                <!-- /.modal -->
                        ';
                    }else{

                    }
                    return $button;
                })
                 ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true);
        }
         
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'project'=>'required|integer|gt:0',
        ]);

        $Block=new BlockModel;
        $Block->name=$request->name;
        $Block->project_id=$request->project;
        $Block->description=$request->description;
        $Block->user_id=Auth::user()->id;
        $Block->save();

        ProjectModel::where("id",$request->project)->update(['delete_status'=>0]);//set to can't delete 

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("block.index")->with("success","Create successfully !");

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
            'project'=>'required',
        ]);

        //check for status_delete or not
        $Blocks = BlockModel::find($id);
        if(count(BlockModel::where("project_id",$Blocks->project_id)->get())==1&&count(ItemModel::where("project_id",$Blocks->project_id)->get())==0){
            ProjectModel::where("id",$Blocks->project_id)->update(['delete_status'=>1]);
        }

        $Block=BlockModel::find($id);
        $Block->name=$request->name;
        $Block->project_id=$request->project;
        $Block->description=$request->description;
        $Block->save();

       ProjectModel::where("id",$request->project)->update(['delete_status'=>0]);//set status_delete

        return json_encode("OK");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        BlockModel::where("id",$id)->delete();
        return \back()->with("success","successfully !");
    }
}
