<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Gate;

class BankController extends Controller
{
	function __construct(){
		$this->middleware('permission:Setting-Bank-List',['only'=>['index']]);
		$this->middleware('permission:Setting-Bank-Create',['only'=>['store']]);
		$this->middleware('permission:Setting-Bank-Edit',['only'=>['update_store']]);
		$this->middleware('permission:Setting-Bank-Delete',['only'=>['delete']]);
	}
    public function index()
    {
    	$data = DB::table("nso007_bank")->select("*")->get();
    	$data1="";
    	if(!isset($data)) dd("OK");
    	else
    	{
    		foreach($data as $key=>$value)
    		{
				$button = "";
				if(Gate::check('Setting-Bank-Edit')){
					$button .= "<button title='Edit' class='btn btn-sm btn-primary' data-id='".$value->id."' data-name='".$value->name."' data-description = '".$value->description."' onclick='edit(this)'><i class='fa fa-edit'></i></button>";
				}
				
				if($value->delete_status==1)
				{
					if(Gate::check('Setting-Bank-Delete')){
						$button .= "<button style='margin-left:10px;' title='Delete' class='btn btn-sm btn-danger' data-id='".$value->id."' data-name='".$value->name."' data-description = '".$value->description."' onclick='delete_promotion(this)'><i class='fa fa-trash'></i></button>";
					}
					
				}
                $data1 .= "
                	<tr>
                		<td>".($key+1)."</td>
                        <td>".$value->name."</td>
                        <td>".$value->description."</td>
						<td>
							".$button."
						</td>
                    </tr>";
            }
    	}
    	return view("setting.bank",["data"=>$data1]);
    }
    public function store(Request $request)
    {
    	$this->validate($request,[
    		'name'=>'required|unique:nso007_bank,name'
    	]);

    	DB::table('nso007_bank')->insert(['name'=>$request->name,'description'=>$request->description]);

    	return redirect()->route("setting_bank.index")->with("success","Bank Created !");
    }
    public function update_store(Request $request)
    {
    	$this->validate($request,[
    		'name'=>'required|unique:nso007_bank,name,'.$request->id
    	]);

    	DB::table('nso007_bank')->where("id",$request->id)->update(['name'=>$request->name,'description'=>$request->description]);

    	return redirect()->route("setting_bank.index")->with("success","Bank Updated !");
	}
	public function delete()
	{
		$id = $_GET['id'];
		DB::table("nso007_bank")->where("id",$id)->where("delete_status",1)->delete();

    	return redirect()->route("setting_bank.index")->with("success","Bank Deleted !");
	}
}
