<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\LoanProcessModel;
use DB;
use DataTables;
use App\AccountChartModel;
use Gate;

class ArrearController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Arrears-List', ['only' => ['index','get_data_index']]);
    }
    public function index()
    {
        $banklist = AccountChartModel::select(DB::raw("CONCAT(id, ' | ',acc_name) as account_name"), "id")
        ->where('id', 11001)
        ->Orwhere('id', 11002)
         ->orderBy('id')
        ->pluck("account_name", "id");
    	return view("arrears.index",compact('banklist'));
    }
    public function get_data_index(Request $request)
    {
    	$search = $request->input('search.value');
    	$curr_date = date("Y-m-d");
        $count_total = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
        	->where("nso007_loan.status",1)
        	->where("nso007_loan_process.status",1)
        	->where("nso007_loan_process.date_payment","<",$curr_date)
            ->where("nso007_loan_process.owe_amount_pay",">",0)
        	// ->groupBy("nso007_loan_process.id")
            ->count();
        $count_filter = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
        	->join("nso007_client","nso007_client.id","nso007_loan.client_id")
        	->where("nso007_client.status",1)
        	->where("nso007_loan.status",1)
        	->where("nso007_loan_process.status",1)
        	->where("nso007_loan_process.date_payment","<",$curr_date)
            ->where("nso007_loan_process.owe_amount_pay",">",0)
            ->where(function($query) use ($search){
                $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                $query->orWhere('nso007_loan_process.date_payment' , 'LIKE' , '%'.$search.'%');
            })
            // ->groupBy("nso007_loan_process.id")
            ->count();

        $arrears = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
        	->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
        	->join("nso007_client","nso007_client.id","nso007_loan.client_id")
        	->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
        	->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
        	->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
        	->select(
                "nso007_loan_process.*",
                "nso007_loan.sale_id",
        		"nso007_project_stock.name as project_name",
        		"nso007_category_stock.name as category_name",
        		"nso007_client.name as client_name",
        		"nso007_client.phone as client_phone",
        		DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
        		DB::raw('TIMESTAMPDIFF(DAY,date_payment,"' . $curr_date . '") AS day_late')
        	)
        	->where("nso007_project_stock.status",1)
        	->where("nso007_client.status",1)
        	->where("nso007_item_stock.status",1)
        	->where("nso007_loan.status",1)
        	->where("nso007_sale_detail_stock.status",1)
        	->where("nso007_loan_process.status",1)
        	->where("nso007_loan_process.date_payment","<",$curr_date)
            ->where("nso007_loan_process.owe_amount_pay",">",0)
        	->groupBy("nso007_loan_process.id")
            ->take(20);
            
        return Datatables::of($arrears)
            ->addIndexColumn()
            ->setRowId("id")
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->editColumn('date_payment',function($arrears){
                return date('d-m-Y',strtotime($arrears->date_payment));
            })
            ->editColumn('item_name',function($arrears)
            {
                $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$arrears->sale_id)->select("item_id")->get();
                $item_names="";
                foreach ($sale_item as $key => $value) {
                    $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                    if(isset($sale_item[$key+1])) $item_names.=",";
                }
                return $item_names;
            })
            ->addColumn('action',function($arrears){
                if(Gate::check('Arrears-Pay'))
            	   return "<button class='btn btn-sm btn-info' data-toggle='modal' onclick='display_form_pay(".$arrears->id.")''><i class='fa fa-dollar-sign'></i></button>";
                else return "";
            })
             ->rawColumns([
                'action'=>'action'
            ])
            ->make(true);
    }
}
