<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountChartModel;
use Crypt;
use DB;
use App\JournalModel;
use App\ProjectModel;
use App\LoanProcessModel;
use DataTables;
use Gate;

class AccountingReportsController extends Controller
{
    function __construct()
    {
         $this->middleware('permission:Legder', ['only' => ['ledger','get_ledger','print_ledger']]);
         $this->middleware('permission:Trial-Balance', ['only' => ['trial_balance','get_trial_balance','print_trial_balance']]);
         $this->middleware('permission:Balance-Sheet', ['only' => ['balance_sheet','get_balance_sheet','print_balance_sheet']]);
         $this->middleware('permission:Income-Statement', ['only' => ['income_statement','get_income_statement','print_income_statement']]);
         $this->middleware('permission:Cash-Flow-Type', ['only' => ['cash_flow','cash_flow_list']]);
    }
    public function ledger($id = null, $start = null, $end = null)
    {
        $account_chart  = AccountChartModel::select('id', 'acc_name')
            ->pluck('acc_name', 'id')
            ->prepend('Please Select', '');
        if (empty($id) && empty($start) && empty($end)) {
            return view('accounting.reports.ledger', ['account_chart' => $account_chart]);
        } else {
            $acc_code   = Crypt::decrypt($id);
            $start_date = Crypt::decrypt($start);
            $end_date   = Crypt::decrypt($end);
            return view('accounting.reports.ledger', ['acc_code' => $acc_code, 'start_date' => $start_date, 'end_date' => $end_date, 'account_chart' => $account_chart]);
        }
    }
    public function get_ledger(Request $request)
    {
        $table = '';
        if ($request->isMethod('get')) {
            // $account_chart = AccountChartModel::all();
            $account_chart = DB::table('nso007_account_chart as chart')
                ->join('nso007_journal as jn', 'jn.journal_acccode', '=', 'chart.id')
                ->select('chart.id', 'chart.acc_name')
                ->groupBy('chart.id')
                ->get();
            // dd($account_chart);
            if(count($account_chart)>0)
            {
                foreach ($account_chart as $key => $chart) {
                    $start_amount = 0;
                    $start_date = date('Y-m-d', strtotime('first day of this month'));
                    $end_date = date('Y-m-d', strtotime('last day of this month'));
                    $start_journal = JournalModel::select('journal_debit as d', 'journal_credit as c','journal_acccode as id')
                        ->where([['journal_acccode', $chart->id], ['journal_paydate', '<', $start_date]])
                        ->get();
                    foreach ($start_journal as $index => $value) {
                        // $balance = $value->d - $value->c;
                        // $start_amount += $balance;
                        $code       = $value->id;
                        $code       = (string) $code;
                        $id         = $code[0];
                       if($id == 1 || $id == 5)
                       {
                           $balance = $value->d - $value->c;
                           $start_amount += $balance;
                       }
                       else
                       {
                           $balance = $value->c - $value->d;
                           $start_amount += $balance;
                       }
                    }
                    // dd($start_amount);

                    $table .=   '<tr class="ledger-section">
                            <th colspan="4">Account >> ' . $chart->id . ' ' . $chart->acc_name . '</th>
                            <th colspan="4">Beginning Account Balance</th>
                            <th></th>
                            <th>' . ($start_amount>0?$start_amount:"(".abs($start_amount).")") . '</th>
                            <th></th>
                        </tr>';
                    // $journal = JournalModel::where('journal_acccode', $chart->id)->whereBetween('journal_paydate', [$start_date, $end_date])->get();
                    $journal = DB::table('nso007_journal as jn')
                        ->join('users','users.id','jn.journal_by')
                        ->select('jn.*',DB::raw('users.name AS user'))
                        ->where('journal_acccode', $chart->id)
                        ->whereBetween('journal_paydate', [$start_date, $end_date])->get();
                    // dd($journal);
                    $balance_amount = 0;
                    foreach ($journal as $k => $jn) {
                        // $debit = floatval($jn->journal_debit);
                        // $credit = floatval($jn->journal_credit);
                        // $amount = $debit - $credit;
                        $debit = floatval($jn->journal_debit);
                        $credit = floatval($jn->journal_credit);
                        $code       = $jn->journal_acccode;
                        $code       = (string) $code;
                        $id         = $code[0];
                       if($id == 1 || $id == 5)
                       {
                           $amount = $debit - $credit;
                       }
                       else
                       {
                           $amount = $credit - $debit;
                       }
                        // dd($amount);
                        $balance_amount += floatval($amount);
                        // dd(floatval($jn->journal_debit+100));
                        $total_amount = $balance_amount;
                        if ($balance_amount < 0) {
                            $total_amount = "(" . abs($balance_amount) . ")";
                        }
                        $table .=   '<tr>
                                <td>' . $jn->id . '</td>
                                <td></td>
                                <td></td>
                                <td>' . $jn->journal_paydate . '</td>
                                <td>' . $jn->journal_invoice . '</td>
                                <td></td>
                                <td>' . $jn->journal_des . '</td>
                                <td>'.$jn->user.'</td>
                                <td>' . $jn->journal_debit . '</td>
                                <td>' . $jn->journal_credit . '</td>
                                <td>' . $total_amount . '</td>
                            </tr>';
                    }
                    $ending_balace = $start_amount + $balance_amount;
                    $final_balance = $ending_balace;
                    if ($ending_balace < 0) {
                        $final_balance = "(" . abs($final_balance) . ")";
                        $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th></th><th>' . $final_balance . '</th><th></th></tr>';
                    } else {
                        $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th>' . $final_balance . '</th><th></th><th></th></tr>';
                    }
                }
            }
            else
            {
                $table.='<tr class="ledger-section"><td colspan="11" align="center">'.__('administrator.no_data').'</td></tr>';
            }
        }
        else {
            $from = (empty($request->start_date)) ? '' : date('Y-m-d', strtotime($request->start_date));
            $to = (empty($request->end_date)) ? '' : date('Y-m-d', strtotime($request->end_date));
            $account_chart = DB::table('nso007_account_chart as chart')
                ->join('nso007_journal as jn', 'jn.journal_acccode', '=', 'chart.id')
                ->select('chart.id', 'chart.acc_name')
                ->where('jn.journal_acccode', 'LIKE', isset($request->acc_code) ? $request->acc_code : null)
                ->when(request('start_date', ''), function ($q, $from) {
                    $q->where('jn.journal_paydate', '>', $from);
                })
                ->groupBy('chart.id')
                ->get();
            // dd($account_chart);
            if(count($account_chart)>0)
            {
                foreach ($account_chart as $key => $chart) {
                    $start_amount = 0;
                    $start_journal = JournalModel::select('journal_debit as d', 'journal_credit as c','journal_acccode as id')
                        ->where([['journal_acccode', $chart->id], ['journal_paydate', '<', $from]])->get();
                    foreach ($start_journal as $index => $value) {
                        // $balance = $value->d - $value->c;
                        // $start_amount += $balance;
                        $code       = $value->id;
                        $code       = (string) $code;
                        $id         = $code[0];
                        if($id == 1 || $id == 5)
                        {
                            $balance = $value->d - $value->c;
                            $start_amount += $balance;
                        }
                        else
                        {
                            $balance = $value->c - $value->d;
                            $start_amount += $balance;
                        }
                    }
                    // dd($start_amount);
                    $table .=   '<tr class="ledger-section">
                            <th colspan="4">Account >> ' . $chart->id . ' ' . $chart->acc_name . '</th>
                            <th colspan="4">Beginning Account Balance</th>
                            <th></th>
                            <th>' . ($start_amount>0?$start_amount:"(".abs($start_amount).")") . '</th>
                            <th></th>
                        </tr>';
                    $journal = JournalModel::where('journal_acccode', $chart->id)
                        ->when(request('start_date', ''), function ($q) use ($from, $to) {
                            $q->whereBetween('journal_paydate', [$from, $to]);
                        })
                        ->get();
                    // dd($journal);
                    $balance_amount = 0;
                    foreach ($journal as $k => $jn) {
                        // $debit = floatval($jn->journal_debit);
                        // $credit = floatval($jn->journal_credit);
                        // $amount = $debit - $credit;
                        // // dd($amount);
                        // $balance_amount += floatval($amount);
                        // // dd(floatval($jn->journal_debit+100));
                        // $total_amount = $balance_amount;
                        // if ($balance_amount < 0) {
                        //     $total_amount = "(" . abs($balance_amount) . ")";
                        // }
                        $debit = floatval($jn->journal_debit);
                        $credit = floatval($jn->journal_credit);
                        $code       = $jn->journal_acccode;
                        $code       = (string) $code;
                        $id         = $code[0];
                        if($id == 1 || $id == 5)
                        {
                            $amount = $debit - $credit;
                        }
                        else
                        {
                            $amount = $credit - $debit;
                        }
                        // dd($amount);
                        $balance_amount += floatval($amount);
                        // dd(floatval($jn->journal_debit+100));
                        $total_amount = $balance_amount;
                        if ($balance_amount < 0) {
                            $total_amount = "(" . abs($balance_amount) . ")";
                        }
                        $table .=   '<tr>
                                <td>' . $jn->id . '</td>
                                <td></td>
                                <td></td>
                                <td>' . $jn->journal_paydate . '</td>
                                <td>' . $jn->journal_invoice . '</td>
                                <td></td>
                                <td>' . $jn->journal_des . '</td>
                                <td></td>
                                <td>' . $jn->journal_debit . '</td>
                                <td>' . $jn->journal_credit . '</td>
                                <td>' . $total_amount . '</td>
                            </tr>';
                    }
                    $ending_balace = $start_amount + $balance_amount;
                    $final_balance = $ending_balace;
                    if ($ending_balace < 0) {
                        $final_balance = "(" . abs($final_balance) . ")";
                        $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th></th><th>' . $final_balance . '</th><th></th></tr>';
                    } else {
                        $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th>' . $final_balance . '</th><th></th><th></th></tr>';
                    }
                }
            }
            else
            {
                $table.='<tr class="ledger-section"><td colspan="11" align="center">'.__('administrator.no_data').'</td></tr>';
            }
        }
        return $table;
    }

    public function print_ledger(Request $request)
    {
        $from = (empty($request->start_date)) ? '' : date('Y-m-d', strtotime($request->start_date));
        $to = (empty($request->end_date)) ? '' : date('Y-m-d', strtotime($request->end_date));
        $account_chart = DB::table('nso007_account_chart as chart')
            ->join('nso007_journal as jn', 'jn.journal_acccode', '=', 'chart.id')
            ->select('chart.id', 'chart.acc_name')
            ->where('jn.journal_acccode', 'LIKE', isset($request->acc_chart) ? $request->acc_chart : null)
            ->when(request('start_date', ''), function ($q, $from) {
                $q->where('jn.journal_paydate', '>', $from);
            })
            ->groupBy('chart.id')
            ->get();
        // dd($account_chart);
        $table="";
        if(count($account_chart)>0)
        {
            foreach ($account_chart as $key => $chart) {
                $start_amount = 0;
                $start_journal = JournalModel::select('journal_debit as d', 'journal_credit as c','journal_acccode as id')
                    ->where([['journal_acccode', $chart->id], ['journal_paydate', '<', $from]])->get();
                foreach ($start_journal as $index => $value) {
                    // $balance = $value->d - $value->c;
                    // $start_amount += $balance;
                    $code       = $value->id;
                    $code       = (string) $code;
                    $id         = $code[0];
                    if($id == 1 || $id == 5)
                    {
                        $balance = $value->d - $value->c;
                        $start_amount += $balance;
                    }
                    else
                    {
                        $balance = $value->c - $value->d;
                        $start_amount += $balance;
                    }
                }
                // dd($start_amount);
                $table .=   '<tr class="ledger-section">
                        <th colspan="4">Account >> ' . $chart->id . ' ' . $chart->acc_name . '</th>
                        <th colspan="4">Beginning Account Balance</th>
                        <th></th>
                        <th>' . ($start_amount>0?$start_amount:"(".abs($start_amount).")") . '</th>
                        <th></th>
                    </tr>';
                $journal = JournalModel::where('journal_acccode', $chart->id)
                    ->when(request('start_date', ''), function ($q) use ($from, $to) {
                        $q->whereBetween('journal_paydate', [$from, $to]);
                    })
                    ->get();
                // dd($journal);
                $balance_amount = 0;
                foreach ($journal as $k => $jn) {
                    // $debit = floatval($jn->journal_debit);
                    // $credit = floatval($jn->journal_credit);
                    // $amount = $debit - $credit;
                    // // dd($amount);
                    // $balance_amount += floatval($amount);
                    // // dd(floatval($jn->journal_debit+100));
                    // $total_amount = $balance_amount;
                    // if ($balance_amount < 0) {
                    //     $total_amount = "(" . abs($balance_amount) . ")";
                    // }
                    $debit = floatval($jn->journal_debit);
                    $credit = floatval($jn->journal_credit);
                    $code       = $jn->journal_acccode;
                    $code       = (string) $code;
                    $id         = $code[0];
                    if($id == 1 || $id == 5)
                    {
                        $amount = $debit - $credit;
                    }
                    else
                    {
                        $amount = $credit - $debit;
                    }
                    // dd($amount);
                    $balance_amount += floatval($amount);
                    // dd(floatval($jn->journal_debit+100));
                    $total_amount = $balance_amount;
                    if ($balance_amount < 0) {
                        $total_amount = "(" . abs($balance_amount) . ")";
                    }
                    $table .=   '<tr>
                            <td>' . $jn->id . '</td>
                            <td></td>
                            <td></td>
                            <td>' . $jn->journal_paydate . '</td>
                            <td>' . $jn->journal_invoice . '</td>
                            <td></td>
                            <td>' . $jn->journal_des . '</td>
                            <td></td>
                            <td>' . $jn->journal_debit . '</td>
                            <td>' . $jn->journal_credit . '</td>
                            <td>' . $total_amount . '</td>
                        </tr>';
                }
                $ending_balace = $start_amount + $balance_amount;
                $final_balance = $ending_balace;
                if ($ending_balace < 0) {
                    $final_balance = "(" . abs($final_balance) . ")";
                    $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th></th><th>' . $final_balance . '</th><th></th></tr>';
                } else {
                    $table .= '<tr class="ledger-section"><th colspan="8" class="text-center">Ending Account Balace</th><th>' . $final_balance . '</th><th></th><th></th></tr>';
                }
            }
        }
        else
        {
            $table.='<tr class="ledger-section"><td colspan="11" align="center">'.__('administrator.no_data').'</td></tr>';
        }
        // dd("OK");
        return view('accounting.reports.ledger-print',['table'=>$table,'from'=>$from,'to'=>$to]);
    }
    public function trial_balance()
    {
        return view('accounting.reports.trial-balance');
    }
    public function get_trial_balance(Request $request)
    {
       $from           = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
        $to             = empty($request->to) ? date('Y-m-d') : date('Y-m-d', strtotime($request->to));
        $table          = '';
        $debit          = 0;
        $credit         = 0;
        $balance    = 0;
        $account_type   = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')->get();
        // dd($account_type);
        // dd([$from,$to]);
        $trials = [];
        foreach ($account_type as $key => $type) {
            $type_code = (string)$type->id;
            $code_acc_type = $type_code[0];
            $trial_balance = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')

                ->select(DB::raw('SUM(jn.journal_debit) AS debit'),DB::raw('SUM(jn.journal_credit) AS credit'), 'chart.acc_name', 'chart.id')
                ->where('chart.acctype',"LIKE", $code_acc_type."%")->whereBetween('jn.journal_paydate', [$from, $to])
                ->where('jn.journal_audit_status',0)
                ->groupBy('jn.journal_acccode')->get();
            // dd($trial_balance);
            if(count($trial_balance) > 0)
            {
                $table .=    '<tr>
                            <th colspan="3">' . $type->acc_name . '</th>
                        </tr>';
                foreach ($trial_balance as $key => $trial)
                {
                    $code       = $trial->id;
                    $code       = (string) $code;
                    $id         = $code[0];
                    if ($id == 1 || $id == 5)
                    {
                        $balance = $trial->debit-$trial->credit;
                        $debit += $balance;
                    }
                    else {
                        $balance = $trial->credit-$trial->debit;
                        $credit += $balance;
                    }
                    if ($balance < 0) {
                        $balance = "(".abs($balance).")";
                    }
                    switch ($id) {
                        case "1":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td>' . $balance . '</td>
                                            <td></td>
                                        </tr>';
                            break;
                        case "2":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "3":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "4":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "5":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td>' . $balance . '</td>
                                            <td></td>
                                        </tr>';
                            break;
                        default:
                            $table .= '';
                    }
                    array_push($trials,$trial_balance);
                }
            }
        }
        if($debit <0)
        {
            $debit="(".abs($debit).")";
        }
        if($credit<0)
        {
            $credit="(".abs($credit).")";
        }
        $debit = $debit;
        $credit = $credit;
        if(count($trials) > 0)
        {
            $table .=   '<tr>
                        <td class="text-right bold-green">Total :</td>
                        <td class="bold-orange">' . $debit . '</td>
                        <td class="bold-orange">' . $credit . '</td>
                    </tr>';
        }
        if($table == "")
        {
            $table.='<tr><td align="center" colspan="3">'.__('administrator.no_data').'</td></tr>';
        }
        return $table;
    }
    public function print_trial_balance(Request $request)
    {
        $from           = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
        $to             = empty($request->to) ? date('Y-m-d') : date('Y-m-d', strtotime($request->to));
        $table          = '';
        $debit          = 0;
        $credit         = 0;
        $balance    = 0;
        $account_type   = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')->get();
        // dd($account_type);
        // dd([$from,$to]);
        $trials = [];
        foreach ($account_type as $key => $type) {
            $type_code = (string)$type->id;
            $code_acc_type = $type_code[0];
            $trial_balance = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')

                ->select(DB::raw('SUM(jn.journal_debit) AS debit'),DB::raw('SUM(jn.journal_credit) AS credit'), 'chart.acc_name', 'chart.id')
                ->where('chart.acctype',"LIKE", $code_acc_type."%")->whereBetween('jn.journal_paydate', [$from, $to])
                ->where('jn.journal_audit_status',0)
                ->groupBy('jn.journal_acccode')->get();
            // dd($trial_balance);
            if(count($trial_balance) > 0)
            {
                $table .=    '<tr>
                            <th colspan="3">' . $type->acc_name . '</th>
                        </tr>';
                foreach ($trial_balance as $key => $trial)
                {
                    $code       = $trial->id;
                    $code       = (string) $code;
                    $id         = $code[0];
                    if ($id == 1 || $id == 5)
                    {
                        $balance = $trial->debit-$trial->credit;
                        $debit += $balance;
                    }
                    else {
                        $balance = $trial->credit-$trial->debit;
                        $credit += $balance;
                    }
                    if ($balance < 0) {
                        $balance = "(".abs($balance).")";
                    }
                    switch ($id) {
                        case "1":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td>' . $balance . '</td>
                                            <td></td>
                                        </tr>';
                            break;
                        case "2":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "3":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "4":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td></td>
                                            <td>' . $balance . '</td>
                                        </tr>';
                            break;
                        case "5":
                            $table .=   '<tr data-value="'.$trial->id.'" class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($trial->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td>' . $trial->acc_name . '</td>
                                            <td>' . $balance . '</td>
                                            <td></td>
                                        </tr>';
                            break;
                        default:
                            $table .= '';
                    }
                    array_push($trials,$trial_balance);
                }
            }
        }
        if($debit <0)
        {
            $debit="(".abs($debit).")";
        }
        if($credit<0)
        {
            $credit="(".abs($credit).")";
        }
        $debit = $debit;
        $credit = $credit;
        if(count($trials) > 0)
        {
            $table .=   '<tr>
                        <td class="text-right bold-green">Total :</td>
                        <td class="bold-orange">' . $debit . '</td>
                        <td class="bold-orange">' . $credit . '</td>
                    </tr>';
        }
        if($table == "")
        {
            $table.='<tr><td align="center" colspan="3">'.__('administrator.no_data').'</td></tr>';
        }
        return view('accounting.reports.report-print-trial-balance', ['table'=>$table,'from'=>$from,'to'=>$to]);
    }

    public function balance_sheet()
    {
        $projects = ProjectModel::select(
            DB::raw('CONCAT(id," ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id')
            ->prepend('Please Select', '');
        return view('accounting.reports.balance-sheet', ['projects' => $projects]);
    }

    public function get_balance_sheet(Request $request)
    {
        $project_id =  $request->project_id;
        // $from           = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
        // $to             = empty($request->to) ? date('Y-m-d', strtotime('last day of this month')) : date('Y-m-d', strtotime($request->to));
        $from           = empty($request->from) ? "" : date('Y-m-d', strtotime($request->from));
        $to             = empty($request->to) ? "" : date('Y-m-d', strtotime($request->to));
        $table          = '';
        $total_asset    = 0;
        $total_liability = 0;
        $total_equity   = 0;
        $total_liability_and_equity = 0;

        $assets  = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '1%')
            ->get();
        $liabilities    = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '2%')
            ->get();

        $equities       = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '3%')
            ->get();
        // if ($request->isMethod('get')) {
        //assets
        $count_asset = [];
        $count_liability = [];
        $count_equity = [];
        foreach ($assets as $key => $asset) {
            $code = (string)$asset->id;
            $acc_code = $code[0].$code[1];
            $each_asset     = 0;
            $account_assets = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                ->where('chart.acctype','LIKE',$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();

            if(count($account_assets) > 0) {
                $table .=   '<tr>
                                <th colspan="4">' . $asset->acc_name . '</th>
                            </tr>';
                foreach ($account_assets as $index => $account)
                {

                    $balance = $account->balance;
                    $each_asset += $balance;
                    $amount = $balance;

                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }

                    $table .= '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($account->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td>' . $amount . '</td>
                                    <td></td>
                                </tr>';
                    array_push($count_asset,$account_assets);
                }


                $table .= '<tr class="balance_section">
                                <th colspan="2">Total ' . $asset->acc_name . '</th>
                                <th>' . ($each_asset>0?$each_asset:"(".abs($each_asset).")") . '</th>
                                <th></th>
                            </tr>';
            }
            $total_asset += $each_asset;
        }
        if(count($count_asset) > 0)
        {
            $table .=   '<tr class="ending-row-section">
                            <th colspan="2">Total Asset</th>
                            <th>' . ($total_asset>0?$total_asset:"(".abs($total_asset).")") . '</th>
                            <th></th>
                        </tr>';
        }
        //asset

        //liabilities
        foreach ($liabilities as $key => $liability) {
            $each_liability = 0;
            $code = (string)$liability->id;
            $acc_code = $code[0].$code[1];
            $account_liability = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.acctype',"LIKE",$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();


            if(count($account_liability) > 0)
            {
                $table .=   '<tr>
                                <th colspan="4">' . $liability->acc_name . '</th>
                            </tr>';
                foreach ($account_liability as $account) {

                    $balance        = $account->balance;
                    $each_liability += $balance;
                    $amount         = $balance;
                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }
                    $table .=   '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($account->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td></td>
                                    <td>' . $amount . '</td>
                                </tr>';
                    array_push($count_liability,$account_liability);
                }

                $set_liability = $each_liability;

                if ($set_liability < 0) {
                    $set_liability = "(" . abs($set_liability) . ")";
                }
                $table .=   '<tr class="balance_section">
                                    <th colspan="2">Total ' . $liability->acc_name . '</th>
                                    <th></th>
                                    <th>' . $set_liability . '</th>
                                </tr>';
                $total_liability += $each_liability;
            }
        }
        $liability_balance = $total_liability;
        if ($liability_balance < 0)
        {
            $liability_balance = "(" . abs($liability_balance) . ")";
        }
        if(count($count_liability) > 0)
        {
            $table .=   '<tr class="balance_section">
                            <th colspan="2">Total Liability</th>
                            <th></th>
                            <th>' . ($liability_balance>0?$liability_balance:"(".abs($liability_balance).")") . '</th>
                        </tr>';
        }
        //liabilities
        //equity
        foreach ($equities as $equity) {
            $code = (string)$equity->id;
            $acc_code = $code[0];
            $account_equity = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.acctype',"LIKE",$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                // ->whereBetween('jn.journal_paydate', [$from, $to])
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();
            if(count($account_equity) > 0)
            {
                $table          .=   '<tr>
                                <th colspan>' . $equity->acc_name . '</th>
                            </tr>';
                foreach ($account_equity as $account) {

                    $balance        = $account->balance;
                    $total_equity   += $balance;
                    $amount         = $balance;
                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }
                    $table .=   '<tr>
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td></td>
                                    <td>' . $amount . '</td>
                                </tr>';
                }
            }
        }

        //net_income
        //income
        $income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select(DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
            ->where('chart.acctype', 'LIKE', '4%')
            ->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->when(request('from')&&request('to'),function($query) use ($from,$to){
                $query->whereBetween('jn.journal_paydate', [$from, $to]);
            })
            ->first();
        //income
        //expense
        $expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select(DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', '5%')
            ->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->when(request('from')&&request('to'),function($query) use ($from,$to){
                $query->whereBetween('jn.journal_paydate', [$from, $to]);
            })
            ->first();
        //expense
        $net_income = abs($income->balance) - abs($expense->balance);
        $earning_current = $net_income;
        if(!empty($net_income))
        {
            if($net_income < 0)
            {
                $earning_current = "(".abs($net_income).")";
            }
            $table .=   '<tr class="clickable-row" data-href="' . route('accounting-report.income-statement') . '">
                            <td>31004</td>
                            <td>Retained Earnings-current period</td>
                            <td></td>
                            <td>' . $earning_current . '</td>
                        </tr>';
        }
        //net_income
        $total_equity = abs($total_equity) + $net_income;
        $total_liability_and_equity = abs($total_liability) + $total_equity;
        if(!empty($total_equity) || !empty($total_liability_and_equity))
        {
            if($total_equity < 0)
            {
                $total_equity = "(".abs($total_equity). ")";
            }
            $table .=   '<tr class="balance_section">
                            <th colspan="2">Total Equities</th>
                            <th></th>
                            <th>' . $total_equity . '</th>
                        </tr>
                        <tr class="ending-row-section">
                            <th colspan="2">Total Liability and Equities</th>
                            <th></th>
                            <th>' . ($total_liability_and_equity>0?$total_liability_and_equity:"(".abs($total_liability_and_equity).")") . '</th>
                        </tr>';
        }
        if($table == '')
        {
            $table.= '<tr align="center"><th>'.__('administrator.no_data').'</th></tr>';
        }
        //equity
        // } else {

        // }
        return $table;
    }
    public function print_balance_sheet(Request $request)
    {

        $project_id =  $request->project_id;
        // $from           = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
        // $to             = empty($request->to) ? date('Y-m-d', strtotime('last day of this month')) : date('Y-m-d', strtotime($request->to));
        $from           = empty($request->from) ? "" : date('Y-m-d', strtotime($request->from));
        $to             = empty($request->to) ? "" : date('Y-m-d', strtotime($request->to));
        $table          = '';
        $total_asset    = 0;
        $total_liability = 0;
        $total_equity   = 0;
        $total_liability_and_equity = 0;

        $assets  = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '1%')
            ->get();
        $liabilities    = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '2%')
            ->get();

        $equities       = DB::table('nso007_account_chart as chart')
            ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
            ->select('chart.id', 'chart.acc_name')
            ->where('type.id', 'LIKE', '3%')
            ->get();
        // dd($liabilities);
        // if ($request->isMethod('get')) {
        //assets
        $count_asset = [];
        $count_liability = [];
        $count_equity = [];
        foreach ($assets as $key => $asset) {
            $code = (string)$asset->id;
            $acc_code = $code[0].$code[1];
            $each_asset     = 0;
            $account_assets = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                ->where('chart.acctype','LIKE',$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                // ->whereBetween('jn.journal_paydate', [$from, $to])
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();

            if(count($account_assets) > 0) {
                $table .=   '<tr>
                                <th colspan="3">' . $asset->acc_name . '</th>
                            </tr>';
                foreach ($account_assets as $index => $account)
                {

                    $balance = $account->balance;
                    $each_asset += $balance;
                    $amount = $balance;

                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }

                    $table .= '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($account->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td>' . $amount . '</td>
                                </tr>';
                    array_push($count_asset,$account_assets);
                }


                $table .= '<tr class="balance_section">
                                <th colspan="2">Total ' . $asset->acc_name . '</th>
                                <th>' . ($each_asset>0?$each_asset:"(".abs($each_asset).")") . '</th>
                            </tr>';
            }
            $total_asset += $each_asset;
        }
        if(count($count_asset) > 0)
        {
            $table .=   '<tr class="ending-row-section">
                            <th colspan="2">Total Asset</th>
                            <th>' . ($total_asset>0?$total_asset:"(".abs($total_asset).")") . '</th>
                        </tr>';
        }
        //asset

        //liabilities
        foreach ($liabilities as $key => $liability) {
            $each_liability = 0;
            $code = (string)$liability->id;
            $acc_code = $code[0].$code[1];
            $account_liability = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.acctype',"LIKE",$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                // ->whereBetween('jn.journal_paydate', [$from, $to])
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();


            if(count($account_liability) > 0)
            {
                $table .=   '<tr>
                                <th colspan="3">' . $liability->acc_name . '</th>
                            </tr>';
                foreach ($account_liability as $account) {

                    $balance        = $account->balance;
                    $each_liability += $balance;
                    $amount         = $balance;
                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }
                    $table .=   '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($account->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td>' . $amount . '</td>
                                </tr>';
                    array_push($count_liability,$account_liability);
                }

                $set_liability = $each_liability;

                if ($set_liability < 0) {
                    $set_liability = "(" . abs($set_liability) . ")";
                }
                $table .=   '<tr class="balance_section">
                                    <th colspan="2">Total ' . $liability->acc_name . '</th>
                                    <th>' . $set_liability . '</th>
                                </tr>';
                $total_liability += $each_liability;
            }
        }
        $liability_balance = $total_liability;
        if ($liability_balance < 0)
        {
            $liability_balance = "(" . abs($liability_balance) . ")";
        }
        if(count($count_liability) > 0)
        {
            $table .=   '<tr class="balance_section">
                            <th colspan="2">Total Liability</th>
                            <th>' . ($liability_balance>0?$liability_balance:"(".abs($liability_balance).")") . '</th>
                        </tr>';
        }
        //liabilities
        //equity
        foreach ($equities as $equity) {
            $code = (string)$equity->id;
            $acc_code = $code[0].$code[1];
            $account_equity = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.acctype',"LIKE",$acc_code."%")
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->where('jn.journal_by_project',$project_id);
                })
//                ->where('jn.journal_audit_status',1)
                // ->whereBetween('jn.journal_paydate', [$from, $to])
                ->when(request('from')&&request('to'),function($query) use ($from,$to){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->groupBy('jn.journal_acccode')
                ->get();
            if(count($account_equity) > 0)
            {
                $table          .=   '<tr>
                                <th colspan>' . $equity->acc_name . '</th>
                            </tr>';
                foreach ($account_equity as $account) {

                    $balance        = $account->balance;
                    $total_equity   += $balance;
                    $amount         = $balance;
                    if ($amount < 0) {
                        $amount = "(" . abs($amount) . ")";
                    }
                    $table .=   '<tr>
                                    <td>' . $account->id . '</td>
                                    <td>' . $account->acc_name . '</td>
                                    <td>' . $amount . '</td>
                                </tr>';
                }
            }
        }

        //net_income
        //income
        $income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select(DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
            ->where('chart.acctype', 'LIKE', '4%')
            ->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->when(request('from')&&request('to'),function($query) use ($from,$to){
                $query->whereBetween('jn.journal_paydate', [$from, $to]);
            })
            ->first();
        //income
        //expense
        $expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select(DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', '5%')
            ->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->when(request('from')&&request('to'),function($query) use ($from,$to){
                $query->whereBetween('jn.journal_paydate', [$from, $to]);
            })
            ->first();
        //expense
        $net_income = abs($income->balance) - abs($expense->balance);
        $earning_current = $net_income;
        if(!empty($net_income))
        {
            if($net_income < 0)
            {
                $earning_current = "(".abs($net_income).")";
            }
            $table .=   '<tr class="clickable-row" data-href="' . route('accounting-report.income-statement') . '">
                            <td>31004</td>
                            <td>Retained Earnings-current period</td>
                            <td>' . $earning_current . '</td>
                        </tr>';
        }
        //net_income
        $total_equity = abs($total_equity) + $net_income;
        $total_liability_and_equity = abs($total_liability) + $total_equity;
        if(!empty($total_equity) || !empty($total_liability_and_equity))
        {
            if($total_equity < 0)
            {
                $total_equity = "(".abs($total_equity). ")";
            }
            $table .=   '<tr class="balance_section">
                            <th colspan="2">Total Equities</th>
                            <th>' . $total_equity . '</th>
                        </tr>
                        <tr class="ending-row-section">
                            <th colspan="2">Total Liability and Equities</th>
                            <th>' . ($total_liability_and_equity>0?$total_liability_and_equity:"(".abs($total_liability_and_equity).")") . '</th>
                        </tr>';
        }
        if($table == '')
        {
            $table.= '<tr align="center"><th>'.__('administrator.no_data').'</th></tr>';
        }

        return view('accounting.reports.report-print-balance-sheet',['table'=>$table,'from'=>$from,'to'=>$to]);
    }
    public function income_statement()
    {
        $projects = ProjectModel::select(
            DB::raw('CONCAT(id," ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        return view('accounting.reports.income-statement', ['projects' => $projects]);
    }
    public function get_income_statement(Request $request)
    {

        /*
            $from         = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
            $to           = empty($request->to) ? date('Y-m-d', strtotime('last day of this month')) : date('Y-m-d', strtotime($request->to));
        */

        

        $from           = $request->from;
        $to             = $request->to;
        $last_months    = $request->last_months;
        $project_id     =  $request->project_id;
        $table_income   =   '';
        $table_expense  =   '';
        $journal_acccode_income = $request->journal_acccode_income;
        $journal_acccode_expense = $request->journal_acccode_expense;
        if(isset($request->type_cash)){
            if($request->type_cash==1){//Full Price
                
                $journal_income = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                    ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                    ->where('chart.type_id', 'LIKE', "4%")
                    ->where('jn.journal_status','!=',3)
                    ->when(!empty($project_id),function($q) use($project_id){
                        $q->whereIn('jn.journal_by_project',$project_id);
                    })
        //            ->where('jn.journal_audit_status',1)
                    ->where(function($query) use($from,$to){
                        if(!empty($from)&&!empty($to)){
                            $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                        }
                    })
                    ->where(function($query) use ($journal_acccode_income){
                        if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
                    })
                    ->when(request('last_months'),function($query) use ($last_months){
                        $date = \Globals::the_last_month($last_months);
                        $query->whereBetween('jn.journal_paydate',$date);
                    })
                    ->groupBy('chart.code')->get();
                    // dd($project_id);
            }
            else{//Real Price
                $journal_income = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                    ->select('chart.code as id', 'chart.acc_name','jn.transaction_type', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                    ->whereIn("jn.journal_acccode",['11001','11002'])
                    ->where("jn.journal_status","!=",3)
                    ->where("jn.journal_debit",">",0)
                    ->when(!empty($project_id),function($q) use($project_id){
                        $q->whereIn('jn.journal_by_project',$project_id);
                    })
        //            ->where('jn.journal_audit_status',1)
                    ->where(function($query) use($from,$to){
                        if(!empty($from)&&!empty($to)){
                            $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                        }
                    })
                    ->where(function($query) use ($journal_acccode_income){
                        if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
                    })
                    ->when(request('last_months'),function($query) use ($last_months){
                        $date = \Globals::the_last_month($last_months);
                        $query->whereBetween('jn.journal_paydate',$date);
                    })
                    // ->whereBetween('jn.journal_paydate', [$from, $to])
                    ->groupBy(['chart.code','jn.transaction_type'])
                    ->get();
            }
        }
        else{//Full Price
            $journal_income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
            ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
            ->where('chart.type_id', 'LIKE', "4%")
            ->where('jn.journal_status','!=',3)
            ->when(!empty($project_id),function($q) use($project_id){
                $q->whereIn('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->where(function($query) use($from,$to){
                if(!empty($from)&&!empty($to)){
                    $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                }
            })
            ->where(function($query) use ($journal_acccode_income){
                if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
            })
            ->when(request('last_months'),function($query) use ($last_months){
                $date = \Globals::the_last_month($last_months);
                $query->whereBetween('jn.journal_paydate',$date);
            })
            ->groupBy('chart.code')->get();
        }

        $jn_income = [];
        $journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
            ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.type_id', 'LIKE', "5%")
            ->where('jn.journal_status','!=',3)
            ->when(!empty($project_id),function($q) use($project_id){
                $q->whereIn('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->where(function($query) use($from,$to){
                if(!empty($from)&&!empty($to)){
                    $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                }
            })
            ->where(function($query) use ($journal_acccode_expense){
                if(!empty($journal_acccode_expense)) $query->whereIn("jn.journal_acccode",$journal_acccode_expense);
            })
            ->when(request('last_months'),function($query) use ($last_months){
                $date = \Globals::the_last_month($last_months);
                $query->whereBetween('jn.journal_paydate',$date);
            })
            ->groupBy('chart.code')->get();

        // dd([$journal_income,$journal_expense]);

        $index      = 0;
        $income     = 0;
        $expense    = 0;
        if(count($journal_income) > 0)
        {
            $table_income.='<tr>
                                <th colspan="3">Income</th>
                            </tr>';
            foreach ($journal_income as $key => $ji) {
                $income += $ji->balance;
                $index++;
                /*if($ji->balance < 0)
                {
                    $ji->balance="(".abs($ji->balance).")";
                }*/
                $table_income .=    '<tr class="clickable-row" data-href="javascript:void(0)">
                                    <td>' . $index . '</td>
                                    <td>' . $ji->id . ' - ' . $ji->acc_name.($request->type_cash==2&&!empty($ji->transaction_type)?(" << ".$ji->transaction_type):"") . '</td>
                                    <td>$' . ($ji->balance>0?number_format($ji->balance,2):"(".number_format(abs($ji->balance),2).")") . '</td>
                                </tr>';
                array_push($jn_income,$ji);
            }
        }
        /*if($income<0)
        {
            $income="(".abs($income).")";
        }*/
        if(count($jn_income) > 0)
        {
            $table_income .=    '<tr class="total-section">
                                <th colspan="2">Total Income</th>
                                <th>$' .($income>0?(number_format($income,2)):("(".number_format($income*(-1),2).")")). '</th>
                            </tr>';
        }
        if(count($journal_expense) > 0)
        {
            $table_expense.='<tr class="total-section">
                                <th colspan="3">Expense</th>
                            </tr>';
            foreach ($journal_expense as $key => $je) {
                $index++;
                $expense += $je->balance;
                $table_expense .=   '<tr class="clickable-row" data-href="javascript:void(0)">
                                    <td>' . $index . '</td>
                                    <td>' . $je->id . ' - ' . $je->acc_name . '</td>
                                    <td>$' . ($je->balance>0?number_format($je->balance,2):"(".number_format(abs($je->balance),2).")") . '</td>
                                </tr>';
            }
            $table_expense .=   '<tr class="total-section">
                                <th colspan="2">Total Expense</th>
                                <th>$' . ($expense>=0?(number_format($expense,2)):("(".number_format($expense,2).")")) . '</th>
                            </tr>';
        }
        $net_income = $income - $expense;
        $row_profit_loss='';
        if(!empty($net_income))
        {
            /*if($net_income < 0)
            {
                $net_income = "(".abs($net_income).")";
            }*/
            $row_profit_loss.= '<tr class="total-section">
                                <th colspan="2">Profit NET/Loss</th>
                                <th>$' . ($net_income>=0?(number_format($net_income,2)):("(".number_format($net_income*(-1),2).")")) . '</th>
                            </tr>';
        }
        $table = $table_income . $table_expense . $row_profit_loss;
        if($table == "")
        {
            $table.='<tr align="center"><td colspan="3">No Data</td></tr>';
        }
        return $table;
    }
    public function print_income_statement(Request $request)
    {
        /*$from           = empty($request->from) ? date('Y-m-d', strtotime('first day of this month')) : date('Y-m-d', strtotime($request->from));
        $to             = empty($request->to) ? date('Y-m-d', strtotime('last day of this month')) : date('Y-m-d', strtotime($request->to));*/
        $from           = $request->from;
        $to             = $request->to;
        $project_id =  $request->journal_by_project;
        $last_months    = $request->last_months;
        $journal_acccode_income = $request->journal_acccode_income;
        $journal_acccode_expense = $request->journal_acccode_expense;
        $table_income   =   '';
        $table_expense  =   '';
        if(isset($request->type_cash)){
            if($request->type_cash==1){//Full Price
                $journal_income = DB::table('nso007_journal as jn')
                        ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                        ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                        ->where('chart.type_id', 'LIKE', "4%")
                        ->where('jn.journal_status','!=',3)
                        ->when(!empty($project_id),function($q) use($project_id){
                            $q->whereIn('jn.journal_by_project',$project_id);
                        })
            //            ->where('jn.journal_audit_status',1)
                        // ->whereBetween('jn.journal_paydate', [$from, $to])
                        ->where(function($query) use($from,$to){
                            if(!empty($from)&&!empty($to)){
                                $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                            }
                        })
                        ->where(function($query) use ($journal_acccode_income){
                            if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
                        })
                        ->when(request('last_months'),function($query) use ($last_months){
                            $date = \Globals::the_last_month($last_months);
                            $query->whereBetween('jn.journal_paydate',$date);
                        })
                        ->groupBy('chart.code')->get();
            }
            else{//Real Price
                $journal_income = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                    ->select('chart.code as id', 'chart.acc_name', 'jn.transaction_type',DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                    ->whereIn("jn.journal_acccode",['11001','11002'])
                    ->where("jn.journal_status","!=",3)
                    ->where("jn.journal_debit",">",0)
                    ->when(!empty($project_id),function($q) use($project_id){
                        $q->whereIn('jn.journal_by_project',$project_id);
                    })
        //            ->where('jn.journal_audit_status',1)
                    // ->whereBetween('jn.journal_paydate', [$from, $to])
                    ->where(function($query) use($from,$to){
                        if(!empty($from)&&!empty($to)){
                            $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                        }
                    })
                    ->where(function($query) use ($journal_acccode_income){
                        if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
                    })
                    ->when(request('last_months'),function($query) use ($last_months){
                        $date = \Globals::the_last_month($last_months);
                        $query->whereBetween('jn.journal_paydate',$date);
                    })
                    ->groupBy(['chart.code','jn.transaction_type'])
                    ->get();
            }
        }
        else{//Full Price
            $journal_income = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.type_id', 'LIKE', "4%")
                ->where('jn.journal_status','!=',3)
                ->when(!empty($project_id),function($q) use($project_id){
                    $q->whereIn('jn.journal_by_project',$project_id);
                })
    //            ->where('jn.journal_audit_status',1)
                // ->whereBetween('jn.journal_paydate', [$from, $to])
                ->where(function($query) use($from,$to){
                    if(!empty($from)&&!empty($to)){
                        $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                    }
                })
                ->where(function($query) use ($journal_acccode_income){
                    if(!empty($journal_acccode_income)) $query->whereIn("jn.journal_acccode",$journal_acccode_income);
                })
                ->when(request('last_months'),function($query) use ($last_months){
                    $date = \Globals::the_last_month($last_months);
                    $query->whereBetween('jn.journal_paydate',$date);
                })
                ->groupBy('chart.code')->get();
        }

        $jn_income = [];
        $journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
            ->select('chart.code as id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.type_id', 'LIKE', "5%")
            ->where('jn.journal_status','!=',3)
            ->when(!empty($project_id),function($q) use($project_id){
                $q->whereIn('jn.journal_by_project',$project_id);
            })
//            ->where('jn.journal_audit_status',1)
            // ->whereBetween('jn.journal_paydate', [$from, $to])
            ->where(function($query) use($from,$to){
                if(!empty($from)&&!empty($to)){
                    $query->whereBetween('jn.journal_paydate', [date("Y-m-d",strtotime($from)), date("Y-m-d",strtotime($to))]);
                }
            })
            ->where(function($query) use ($journal_acccode_expense){
                if(!empty($journal_acccode_expense)) $query->whereIn("jn.journal_acccode",$journal_acccode_expense);
            })
            ->when(request('last_months'),function($query) use ($last_months){
                $date = \Globals::the_last_month($last_months);
                $query->whereBetween('jn.journal_paydate',$date);
            })
            ->groupBy('chart.code')->get();

        // dd([$journal_income,$journal_expense]);

        $index      = 0;
        $income     = 0;
        $expense    = 0;
        if(count($journal_income) > 0)
        {
            $table_income.='<tr>
                                <th colspan="3">Income</th>
                            </tr>';
            foreach ($journal_income as $key => $ji) {
                $income += $ji->balance;
                $index++;
                /*if($ji->balance < 0)
                {
                    $ji->balance="(".abs($ji->balance).")";
                }*/
                $table_income .=    '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($ji->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $index . '</td>
                                    <td>' . $ji->id . ' - ' . $ji->acc_name.($request->type_cash==2&&!empty($ji->transaction_type)?(" << ".$ji->transaction_type):"") . '</td>
                                    <td>$' . ($ji->balance>0?number_format($ji->balance,2):("(".number_format(abs($ji->balance),2).")")) . '</td>
                                </tr>';
                array_push($jn_income,$ji);
            }
        }
        /*if($income<0)
        {
            $income="(".abs($income).")";
        }*/
        if(count($jn_income) > 0)
        {
            $table_income .=    '<tr class="total-section">
                                <th colspan="2">Total Income</th>
                                <th>$' .($income>=0?(number_format($income,2)):("(".number_format($income*(-1),2).")")). '</th>
                            </tr>';
        }
        if(count($journal_expense) > 0)
        {
            $table_expense.='<tr class="total-section">
                                <th colspan="3">Expense</th>
                            </tr>';
            foreach ($journal_expense as $key => $je) {
                $index++;
                $expense += $je->balance;
                $table_expense .=   '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($je->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td>' . $index . '</td>
                                    <td>' . $je->id . ' - ' . $je->acc_name . '</td>
                                    <td>$' . ($je->balance>0?number_format($je->balance,2):"(".number_format(abs($je->balance),2).")") . '</td>
                                </tr>';
            }
            $table_expense .=   '<tr class="total-section">
                                <th colspan="2">Total Expense</th>
                                <th>$' . ($expense>=0?number_format($expense,2):("(".number_format($expense*(-1),2).")")) . '</th>
                            </tr>';
        }
        $net_income = $income - $expense;
        $row_profit_loss='';
        if(!empty($net_income))
        {
            /*if($net_income < 0)
            {
                $net_income = "(".abs($net_income).")";
            }*/
            $row_profit_loss.= '<tr class="total-section">
                                <th colspan="2">Profit NET/Loss</th>
                                <th>$' .($net_income>=0?number_format($net_income,2):("(".number_format($net_income*(-1),2).")")). '</th>
                            </tr>';
        }
        $table = $table_income . $table_expense . $row_profit_loss;
        if($table == "")
        {
            $table.='<tr align="center"><td colspan="3">No Data</td></tr>';
        }
        $project_name = optional(DB::table("nso007_project_stock")->where("id",$project_id)->first())->name;
        // dd($project_id);
        return view('accounting.reports.report-print-income-statement', ['table'=>$table,'from'=>$from,'to'=>$to,'project_name'=>$project_name]);
    }
    public function cash_flow(){
        // dd(date('Y-m-d',strtotime('first day of this year')),date('Y-m-d',strtotime('last day of this year')));
        return view('accounting.reports.cash-flow');
    }
    public function cash_flow_list(Request $request){
        $firstDayofthisYear             = date('Y')."-01-01";
        $firstDayofthisYear             = date('Y-m-d',strtotime($firstDayofthisYear));
        $firstDayofLastMonthofthisYear  = date('Y')."-12-01";
        $lastDayofthisYear              = date('Y-m-t',strtotime($firstDayofLastMonthofthisYear));
        $start_date                     = empty($request->start_date)?$firstDayofthisYear:date('Y-m-d',strtotime($request->start_date));
        $end_date                       = empty($request->end_date)?$lastDayofthisYear:date('Y-m-d',strtotime($request->end_date));
        $table                          = '<table class="table table-bordered table-hover"><thead><tr>';
        $months                         = LoanProcessModel::select(DB::raw('YEAR(date_payment) year, MONTH(date_payment) month'))
            ->where(function($q) use($start_date,$end_date){
                $q->whereBetween('date_payment',[$start_date,$end_date]);
            })
            ->where("status",1)
            ->groupby('year','month')->get();
        $arrayMonth     = [];
        $arrayStartDate = [];
        $arrayClient    = DB::table('nso007_client as client')
            ->join('nso007_loan as loan','loan.client_id','client.id')
            ->select('client.name as name','client.id')->where("loan.status",1)->get();

        foreach($months as $k => $month){
            $newMonth = $month->year."-".$month->month."-1";
            array_push($arrayStartDate,date('Y-m-d',strtotime($newMonth)));
        }
        foreach($arrayStartDate as $i => $date){
            $endDate = date("Y-m-t", strtotime($date));
            $pairDate = array('start' => $date,'end'=> $endDate);
            array_push($arrayMonth,$pairDate);
        }
        $table .= '<th></th><th></th>';
        foreach($arrayMonth as $key => $IndexMonth){
            $table .= '<th>'.date('F Y',strtotime($IndexMonth['start'])).'</th>';
        }
        //body table
        $table .= '<th>Total</th></tr></thead><tbody>';

        $total_rowColumn = 0;
        foreach($arrayClient as $key => $client){
            $total_row = 0;
            $table .= '<tr><td>'.($key+1).'</td><td>'.($client->name).'</td>';
            foreach($arrayMonth as $index => $keyMonth){
                $loanProcess = DB::table('nso007_loan_process as process')
                    ->join('nso007_loan as loan','loan.id','process.loan_id')
                    ->join('nso007_client as client','client.id','loan.client_id')
                    ->select(DB::raw('SUM(process.owe_amount) AS payment'))
                    ->where([['client.id',$client->id],['process.owe_amount_pay','>',0]])
                    ->whereBetween('date_payment',[$keyMonth['start'],$keyMonth['end']])
                    ->where("process.status",1)
                    ->first();
                $table .= '<td>'.$loanProcess->payment.'</td>';
                $total_row += $loanProcess->payment;
            }
            $table .= '<td>'.$total_row.'</td></tr>';
        }
        $table .= '</tbody><tfoot><th></th><th>Total</th>';
        foreach($arrayMonth as $a => $ArrM){
            $total_column = 0;
            foreach($arrayClient as $b => $ArrC){
                $loanProcess = DB::table('nso007_loan_process as process')
                    ->join('nso007_loan as loan','loan.id','process.loan_id')
                    ->join('nso007_client as client','client.id','loan.client_id')
                    ->select(DB::raw('SUM(process.owe_amount) AS payment'))
                    ->where([['client.id',$ArrC->id],['process.owe_amount_pay','>',0]])
                    ->whereBetween('date_payment',[$ArrM['start'],$ArrM['end']])
                    ->where("process.status",1)
                    ->first();
                $total_column += $loanProcess->payment;
            }

            $table .= '<th>'.$total_column.'</th>';
            $total_rowColumn += $total_column;
        }
        $table .= '<th>'.$total_rowColumn.'</th></tfoot></table>';
        // echo $table;exit();
        return $table;
    }
    public function cash_report(Request $request){
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $cash_type  = $request->cash_type;
                $last_months = $request->last_months;
                $ref_account_chart = $request->ref_account_chart;
                $transaction_type = $request->transaction_type;
                $count_total = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftJoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id',
                                    'jn.ref_account_chart'
                                )
                                ->where("jn.journal_status","!=",3)
                                ->whereIn("jn.journal_acccode",['11001','11002'])
                                ->orderBy("jn.journal_paydate","ASC")
                                ->count();
                $count_filter = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftJoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id',
                                    'jn.ref_account_chart',
                                    'jn.transaction_type'
                                )
                                ->whereIn("jn.journal_acccode",['11001','11002'])
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id)){
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                    }
                                })
                                ->where(function($query) use ($cash_type){
                                    if(!empty($cash_type)){
                                        $query->where('jn.journal_acccode',$cash_type);
                                    }
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($ref_account_chart){
                                    if(!empty($ref_account_chart)){
                                        $query->whereIn("ref_account_chart",$ref_account_chart);

                                    }
                                })
                                ->where(function($query) use ($transaction_type){
                                    if(!empty($transaction_type)){
                                        $query->whereIn("transaction_type",$transaction_type);
                                    }
                                })
                                ->where("jn.journal_status","!=",3)
                                ->orderBy("jn.journal_paydate","ASC")
                                ->count();
                $data = DB::table('nso007_journal as jn')
                            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                            ->leftJoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                            ->select(
                                'chart.acc_name',
                                'chart.code as account_code',
                                'jn.id',
                                'jn.journal_des',
                                'jn.journal_debit',
                                'jn.journal_credit',
                                'jn.journal_invoice',
                                'jn.journal_paydate',
                                'jn.voucher_type',
                                'jn.voucher_ref',
                                'jn.journal_status',
                                'project.name as project_name',
                                'jn.journal_tran_id as tran_id',
                                'jn.ref_account_chart',
                                'jn.transaction_type'
                            )
                            ->whereIn("jn.journal_acccode",['11001','11002'])
                            ->where(function($query) use ($project_id){
                                if(!empty($project_id))
                                    $query->whereIn("jn.journal_by_project",$project_id);
                            })
                            ->where(function($query) use ($cash_type){
                                if(!empty($cash_type)){
                                    $query->where('jn.journal_acccode',$cash_type);
                                }
                            })
                            ->where(function($query) use ($start_date,$end_date){
                                if(!empty($start_date)&&!empty($end_date)){
                                    $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                }
                            })
                            ->where(function($query) use ($last_months){
                                if(!empty($last_months)){
                                    $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                }
                            })
                            ->where(function($query) use ($ref_account_chart){
                                if(!empty($ref_account_chart)){
                                    $query->whereIn("ref_account_chart",$ref_account_chart);
                                }
                            })
                            ->where(function($query) use ($transaction_type){
                                if(!empty($transaction_type)){
                                    $query->whereIn("transaction_type",$transaction_type);
                                }
                            })
                            ->where("jn.journal_status","!=",3)
                            ->orderBy("jn.journal_paydate","ASC")
                            ->get();
            $return_value = array();
            $sum = 0 ;
            foreach($data as $key=>$value){
                $sum += $value->journal_debit - $value->journal_credit;
                $return_value[$key]['journal_paydate'] = $value->journal_paydate;
                $return_value[$key]['project_name'] = $value->project_name;
                $return_value[$key]['acc_name'] = $value->acc_name;
                $return_value[$key]['journal_des'] = $value->journal_des;
                $return_value[$key]['journal_debit'] = $value->journal_debit;
                $return_value[$key]['journal_credit'] = $value->journal_credit;
                $return_value[$key]['balance'] = $sum;
                $return_value[$key]['ref_account_chart'] = $value->ref_account_chart;
                $return_value[$key]['transaction_type'] = $value->transaction_type;
            }
            return DataTables::of($return_value)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn("journal_debit",function($data){
                    return "$".number_format($data['journal_debit'],2);
                })
                ->editColumn("journal_credit",function($data){
                    return "$".number_format($data['journal_credit'],2);
                })
                ->addColumn("balance",function($data){
                    return "$".number_format($data['balance'],2);
                })
                ->editColumn('account_name',function($data){
                    if($data['transaction_type']=="Cancel Deposit") return "Cancel Deposit";
                    if($data['transaction_type']=="Deposit") return "Deposit";
                    if($data['transaction_type']=="Payment") return "Payment";
                    return optional(DB::table('nso007_account_chart')->where("id",$data['ref_account_chart'])->first())->acc_name;
                })
                ->editColumn('journal_paydate',function($data){
                    return date("d-m-Y",strtotime($data['journal_paydate']));
                })
                ->make(true);
            }
        }
        $transaction_type = array(
            'Payment'=>'Payment',
            'Deposit'=>'Deposit',
            'Cancel Deposit'=>'Cancel Deposit',
            'Acc-Income'=>'Income',
            'Acc-Expense'=>'Expense',
            'Acc-Withdraw'=>'Withdraw',
            'Acc-Capital'=>'Capital'
        );
        return view('accounting.reports.cash-report',compact('projects','transaction_type'));
    }
}
